package jmind.core.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

import jmind.base.util.DataUtil;
import jmind.base.util.DateUtil;

/**
 * <m:date type="year" before=10 after=10 />
 * @author xieweibo
 * @date 2015年3月17日
 */
public class DateTag extends SimpleTagSupport {

    private String name;
    private String type = "year";
    private int before;
    private int after;
    // 其他属性
    private String attr;

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public int getBefore() {
        return before;
    }

    public void setBefore(int before) {
        this.before = before;
    }

    public int getAfter() {
        return after;
    }

    public void setAfter(int after) {
        this.after = after;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void doTag() throws JspException, IOException {
        StringBuilder sb = new StringBuilder("<select name='" + name + "'");
        if (!DataUtil.isEmpty(attr)) {
            sb.append(attr);
        }
        sb.append(">");
        if ("month".equalsIgnoreCase(name)) { // month
            for (int i = 1; i < 13; i++) {
                sb.append("<option value='").append(i).append("'>").append(i).append("</option>");
            }
        } else { // year
            int currentYear = DateUtil.getCurrentYear();
            for (int i = (currentYear - before); i < currentYear; i++) {
                sb.append("<option value='").append(i).append("'>").append(i).append("</option>");
            }
            sb.append("<option  selected='selected'  value='").append(currentYear).append("'>").append(currentYear)
                    .append("</option>");
            for (int i = 1; i <= after; i++) {
                sb.append("<option value='").append(currentYear + i).append("'>").append(currentYear + i)
                        .append("</option>");
            }
        }
        sb.append("</select>");
        getJspContext().getOut().print(sb);
    }

}