package jmind.core.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import jmind.base.util.DataUtil;
import jmind.core.http.HttpClient;
import jmind.base.lang.Pair;
import jmind.core.log.LogUtil;
import jmind.base.util.GlobalConstants;

import org.slf4j.Logger;

/**
 * http://xiaoa7.iteye.com/blog/1262034
 * @author xieweibo
 * @date 2015年7月9日
 */

public class HttpUtil {
    private static final Logger logger = LogUtil.getLogger(HttpUtil.class);
    private static final HttpClient client = HttpClient.getHttpClient();

    public static void main(String[] args) {
        String s="{\"name\":\"wave\",\"pwd\":\"abcd\"}" ;
       Map<String,String> props= Maps.newHashMap();
       props.put("Content-Type","application/json");
       String a= sendPost("http://localhost:8081/lady",s,props);
        System.err.println(a);
    }

    /**
     * 发送HTTP请求
     * 
     * @param urlString
     * @return 响映对象
     * @throws IOException
     */
    public static String sendPost(String urlString, String content,Map<String,String> props) {
        long start = System.currentTimeMillis();
        HttpURLConnection urlConnection = null;
        String res = null;
        try {
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection) url.openConnection();
            if(!DataUtil.isEmpty(props)){
                for(Map.Entry<String,String> entry:props.entrySet()){
                    urlConnection.setRequestProperty(entry.getKey(),entry.getValue());
                }
            }
        //    urlConnection.setRequestProperty("Content-Type","application/json");
            urlConnection.setConnectTimeout(1000);
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.getOutputStream().write(content.getBytes("UTF-8"));
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
            InputStream in = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = bufferedReader.readLine();
            StringBuilder builder = new StringBuilder();
            while (line != null) {
                builder.append(line);
                line = bufferedReader.readLine();
            }
            res = builder.toString();
        } catch (Exception e) {
            logger.error(urlString, e);
        } finally {
            long t = System.currentTimeMillis() - start;
            String slow = t > HttpClient.SLOW_TIME ? "slow|" : "";
            logger.debug(slow + "t={},url={},res={}", t, urlString, res);
            if (urlConnection != null)
                urlConnection.disconnect();
        }

        return res;
    }

    /**
     *  HttpClient get
     * @param url
     * @return
     */
    public final static String get(String url) {
        return client.get(url, GlobalConstants.UTF8, 1000);
    }

    /**
     * 
     * @param url
     * @param code 编码默认 UTF-8
     * @param soTimeout 超时时间
     * @return
     */
    public final static String get(String url, final String code, int timeout) {
        return client.get(url, code, timeout);
    }

    public static String post(String url, Map<String, ?> params) {

        return client.post(url, params);
    }

    /**
     * 
     * @param url
     * @param params 参数不用map 是因为参数名可能重复
     * @return
     * @throws IOException
     */
    public static String post(String url, List<Pair<String, String>> params, String code) {

        return client.post(url, params, code, 0);

    }

    /**
     * 上传文件
     * @param url 请求url
     * @param params 参数
     * @param fileName file参数名
     * @param file 文件
     * @return
     */
    public static String postFile(String url, Map<String, ?> params, String fileName, File file) {

        return client.postFile(url, params, fileName, file, GlobalConstants.UTF8);
    }

}
