package jmind.core.support;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * 属性可以忽略大小写 赋值
 * @author xieweibo
 * @date 2014年12月29日
 * @param <T>
 */
public class BeanProperty<T> {

    private Map<String, String> fields;

    private Class<T> clazz;
    private T instance;

    public BeanProperty(Class<T> bean) {
        fields = new HashMap<String, String>();
        this.clazz = bean;
        Field[] fs = bean.getDeclaredFields();
        for (Field f : fs) {
            fields.put(f.getName().toLowerCase(), f.getName());
        }
        try {
            this.instance = bean.newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public String getFieldName(String name) {
        return fields.get(name.toLowerCase());
    }

    public Field getField(String name) throws SecurityException, NoSuchFieldException {
        return clazz.getField(getFieldName(name));
    }

    public void setProperty(String name, Object value) {
        // 用beanUtils  value可以是String 类型 ，会转换成 字段属性类型。 
        // BeanUtils.setProperty(instance, getFieldName(name), value);
        // Date 类型也支持,而且可以是String
        MethodSupport.setProperty(instance, getFieldName(name), value);
        // 直接用 反射机制 value 必须与 字段属性类型一致
        //            getField(name).setAccessible(true);
        //            getField(name).set(instance, value);

    }

    public Object getProperty(String name) {
        return MethodSupport.getPropertyValue(instance, getFieldName(name));
    }

    public T get() {
        return instance;
    }

}
