package jmind.core.spring;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringBeanFactory {

    private static SpringBeanFactory instance;
    private ClassPathXmlApplicationContext context;

    public static SpringBeanFactory getInstance() {
        if (instance == null) {
            instance = new SpringBeanFactory();

        }
        return instance;
    }

    private SpringBeanFactory() {
        context = new ClassPathXmlApplicationContext("spring.xml");
    }

    public SpringBeanFactory(String... name) {
        context = new ClassPathXmlApplicationContext(name);
        context.start();
    }

    public <T> T getBean(final Class<T> clazz) {
        return context.getBean(clazz);
    }

    public <T> T getBean(String name, final Class<T> clazz) {
        return context.getBean(name, clazz);
    }

    public Object getBean(String name) {
        return context.getBean(name);
    }

    public ApplicationContext getContext() {
        return context;
    }

    @Override
    protected void finalize() throws Throwable {
        this.context = null;
        System.out.println(this.getClass().getSimpleName() + " finalize");
        super.finalize();
    }

}
