package jmind.core.spring;

import java.beans.PropertyEditorSupport;

import jmind.base.util.DataUtil;

import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.util.NumberUtils;

/**
 * 设置基本数据类型默认值
 * @see PropertyEditorRegistrySupport
 * @see CustomNumberEditor
 * @author xieweibo
 * @date 2015年7月6日
 */
public class PrimitiveEditor extends PropertyEditorSupport {

    private final Class<? extends Number> numberClass;

    public PrimitiveEditor(Class<? extends Number> numberClass) {
        this.numberClass = numberClass;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        // 其实不传参数会为0， 主要是表单提交为空字符串时会报错
        if (DataUtil.isEmpty(text)) {
            text = "0";
        }
        setValue(NumberUtils.parseNumber(text, this.numberClass));
    }

}
