package jmind.core.spring;

import java.util.Map;

/**
 * bean 定位器
 * @author xieweibo
 * @date 2015年9月8日
 */
public interface BeanLocator {

    public <T> T getBean(final Class<T> clazz);

    public <T> T getBean(String name);

    public boolean containsBean(String name);

    public void removeBean(String name);

    /**
     * 加载动态bean
     * @param clazz
     */
    public void loadBean(Class<?> clazz);

    /**
     * 动态加载bean，带属性
     * @param clazz
     * @param props
     */
    public void loadBean(Class<?> clazz, Map<String, Object> props);
}
