package jmind.core.redis;

import jmind.base.lang.shard.LoadBalance;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 对于 jmind-hynea 服务，可以自己监控服务是否正常
 * Created by xieweibo on 2016/12/1.
 */
public class HyneaLoadBalanceRedis extends LoadBalanceRedis {
    private final List<Redis> redisList;

    public HyneaLoadBalanceRedis(String hosts, int timeout, LoadBalance.Balance b) {
        super(hosts, timeout, b);
        redisList = new ArrayList<>(balance.getShards());
        if (balance.getFisrt() instanceof SingleJedis) {
            startHealthExamination();
        }
    }

    private void startHealthExamination() {
        Timer timer=new Timer("healthExamination",true);
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                healthExamination();
            }
        },TimeUnit.MINUTES.toMillis(1),TimeUnit.SECONDS.toMillis(15));
    }


    private void healthExamination() {
        for (Redis redis : redisList) {
            try {
                boolean health = ((SingleJedis) redis).ping();
                if (balance.getShards().contains(redis)) {
                    if (!health) {
                        balance.getShards().remove(redis);
                    }
                } else {
                    if (health)
                        balance.getShards().add(redis);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
