package jmind.core.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;

/**
 * Created by xieweibo on 2016/10/31.
 */
public class RabbitmqFactory
{
    public static RabbitmqFactory getFactory() {
        return Nested.instance;
    }

    static class Nested {
        private static final RabbitmqFactory instance = new RabbitmqFactory();
    }


    private  final ConcurrentMap<String, ConnectionFactory> RESOURCES = new ConcurrentHashMap<String, ConnectionFactory>();
    private  final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();

    private  ConnectionFactory create(String name, IProperties p){
            System.out.println("create mq factory "+name);
              String prefix="rabbitmq."+name ;
              ConnectionFactory factory = new ConnectionFactory();
              factory.setHost(p.getProperty(prefix+".host"));
              if(p.hasProperty(prefix+".port")){
                  factory.setPort(DataUtil.toInt(p.getProperty(prefix+".port")));
              }
              factory.setAutomaticRecoveryEnabled(true);
              factory.setConnectionTimeout(3000);
              String vhost=p.getProperty(prefix+".vhost");
              if(!DataUtil.isEmpty(vhost)){
                  factory.setVirtualHost(vhost);
              }
              String username=p.getProperty(prefix+".username");
              if(!DataUtil.isEmpty(username)){
                  factory.setUsername(username);
              }
              String password=p.getProperty(prefix+".password");
              if(!DataUtil.isEmpty(password)){
                  factory.setPassword(password);
              }

              return factory;
          }

     public synchronized ConnectionFactory get(String name, IProperties p){
         if(RESOURCES.containsKey(name)){
             return RESOURCES.get(name);
         }
         ConnectionFactory factory = create(name, p);
         RESOURCES.putIfAbsent(name, factory);
         return factory;
     }

     public synchronized Connection getConnection(String name, IProperties p){
         if("1".equals(p.getProperty("rabbitmq."+name+".connections"))){
             if(connections.containsKey(name)){
                 return connections.get(name);
             }
             try {

                 Connection connection = create(name, p).newConnection();
                 connections.putIfAbsent(name,connection);
                 return connection;
             } catch (IOException e) {
                 e.printStackTrace();
             } catch (TimeoutException e) {
                 e.printStackTrace();
             }
         }else{
             try {
                 return get(name,p).newConnection();
             } catch (IOException e) {
                 e.printStackTrace();
             } catch (TimeoutException e) {
                 e.printStackTrace();
             }
         }




         return null ;
     }

}
