package jmind.core.mongodb;

import java.util.List;

import jmind.base.util.DataUtil;

import com.google.common.collect.Lists;

public class MongoPojo {
    // 包名
    private String packageName;
    // 类名
    private String className;
    //  字段
    private List<Field> fields = Lists.newArrayList();

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<Field> getFields() {
        return fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setField(String name, String value, String type,String desc) {
        fields.add(new Field(name, value, type,desc));
    }



    public class Field {

        private String name;
        private String value;
        private String type;
        private String desc ;
        

        public Field(String name, String value, String type,String desc) {
            this.name = name;
            this.value = DataUtil.isEmpty(value) ? name : value;
            this.type = type;
            this.desc=desc;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }



    }

}
