package jmind.core.mongodb;

import java.util.concurrent.atomic.AtomicInteger;

import com.mongodb.DB;
/**
 * 原子操作，用于实现自增长id
 * @author weibo.xie
 * 2011-12-1
 */
public class MongoAtomic extends MongoCollection {

	private AtomicInteger counter;

	public MongoAtomic(DB db) {
		super(db);
		counter = new AtomicInteger(getMax(ID));
	}

	public final int nextInt() {
		return counter.incrementAndGet();
	}

}
