package jmind.core.manager;

import jmind.base.lang.IProperties;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

/**
 * 基于redis 实现的分布式锁
 * Created by xieweibo on 2016/10/26.
 * http://blog.csdn.net/csujiangyu/article/details/51005342
 */
public class RedissonManager {

    public static RedissonClient create(String name, IProperties p){
        String password=p.getProperty("redis."+name+".password");
        Config config = new Config();
        String[] hosts=p.getProperty("redis."+name+".host").split(",");
        String mode = p.getProperty("redis." + name + ".mode");
        if("cluster".equals(mode)){
            config.useClusterServers()
                    .setScanInterval(2000) // cluster state scan interval in milliseconds
                    .addNodeAddress(hosts).setPassword(password);
        }else{
            config.useSingleServer().setAddress(hosts[0]).setPassword(password);
        }
        return Redisson.create(config);
    }
}
