package jmind.core.manager;

import jmind.base.lang.IProperties;
import jmind.base.lang.SourceProperties;

/**
 *  mongodb 池的管理
 * @author weibo.xie
 * 2011-12-1
 */
public class MongoManager extends AbstractMongoManager {

    private static volatile MongoManager manager = null;

    public static MongoManager getInstance() {
        if (manager == null) {
            synchronized (MongoManager.class) {
                if (manager == null) {
                    manager = new MongoManager();
                }
            }
        }
        return manager;
    }

    @Override
    public IProperties getProperties() {
        return SourceProperties.getDataSource();
    }

}
