package jmind.core.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 一般日志操作
 * @author xieweibo
 *
 */
public abstract class LogUtil {

    public static final Logger log = LoggerFactory.getLogger(LogUtil.class);

    private static final Logger htmlLog = LoggerFactory.getLogger("html");

    public static final Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    public static final Logger getHtmlLogger() {
        return htmlLog;
    }

    public static void exeTime(long start, String method) {
        htmlLog.info(method + ",time=" + (System.currentTimeMillis() - start));
    }

    public static void debug(String msg) {
        log.debug(msg);
    }

    public static void debug(String marker, Object... msg) {
        log.debug(marker, msg);
    }

    public static void info(String msg) {
        log.info(msg);
    }

    public static void info(String marker, Object... msg) {
        log.info(marker, msg);
    }

    public static void error(String marker, Object... msg) {
        log.error(marker, msg);
    }

    public static void error(Throwable e) {
        log.error("", e);
    }

    public static void error(Class<?> clazz, Throwable e) {
        getLogger(clazz).error("", e);
    }
}
