package jmind.core.json;

import com.alibaba.fastjson.serializer.SerializerFeature;

/**
 * 解决fastjson把对象转化成json避免$ref 问题
 * http://blog.csdn.net/zengnm/article/details/50846388
 * 
 * @author wbxie
 * 2014年6月20日
 */
public class JSONObject extends com.alibaba.fastjson.JSONObject {

    // 解决自引用问题
    @Override
    public String toString() {
        return toJSONString(this, SerializerFeature.DisableCircularReferenceDetect);
    }

    //  解决自引用问题 同时格式化日期
    @Override
    public String toJSONString() {
        return toJSONString(this, SerializerFeature.DisableCircularReferenceDetect,
                SerializerFeature.WriteDateUseDateFormat);
    }

    public String toString(String dateFormat) {
        return toJSONStringWithDateFormat(this, dateFormat, SerializerFeature.DisableCircularReferenceDetect);
    }

    public static  String toPrettyString(Object o){
       return toJSONString(o,SerializerFeature.DisableCircularReferenceDetect,SerializerFeature.PrettyFormat,SerializerFeature.WriteDateUseDateFormat);
    }

}
