package jmind.core.jdbc;

import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;

import javax.sql.DataSource;
import java.sql.SQLException;

/**
 *
 * @author weibo.xwb
 * @date 2017/12/19
<bean id="dataSource" class="com.alibaba.druid.pool.DruidDataSource" init-method="init" destroy-method="close">
<property name="url" value="jdbc:mysql://localhost:3306/wave?autoReconnect=true&amp;useUnicode=true&amp;characterEncoding=UTF-8&amp;serverTimezone=UTC" />
<property name="username" value="root" />
<property name="password" value="mysql" />
<!--mergeStat 合并sql统计，wall防火墙-->
<property name="filters" value="mergeStat,wall" />
<property name="maxActive" value="20" />
<property name="initialSize" value="1" />
<property name="maxWait" value="60000" />
<property name="minIdle" value="1" />
<property name="timeBetweenEvictionRunsMillis" value="3000" />
<property name="minEvictableIdleTimeMillis" value="300000" />
<property name="validationQuery" value="SELECT 1" />
<property name="testWhileIdle" value="true" />
<property name="testOnBorrow" value="false" />
<property name="testOnReturn" value="false" />
<property name="poolPreparedStatements" value="true" />
<property name="maxPoolPreparedStatementPerConnectionSize" value="20" />
</bean>
 */
public class DruidDataSource extends DataSourceFactory {
    @Override
    public DataSource getSource(String name, IProperties p) {
        com.alibaba.druid.pool.DruidDataSource ds=new com.alibaba.druid.pool.DruidDataSource();
        String url = p.getProperty("jdbc." + name + ".url");
        System.out.println("jdbc." + name + ".url=" + url);
        if (DataUtil.isEmpty(url)) {
            return null;
        }
        ds.setUrl(url);
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        if (url.startsWith("jdbc:oracle")) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
            ds.setValidationQuery("SELECT * FROM DUAL");
        } else if (url.startsWith("jdbc:sqlserver")) {
            driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

        } else {
            ds.setValidationQuery("SELECT 1");
        }
        ds.setDriverClassName(driverClassName);
        ds.setUsername(p.getProperty("jdbc." + name + ".username"));
        ds.setPassword(p.getProperty("jdbc." + name + ".password"));
        // 最大空闲数
        ds.setInitialSize(3);
        ds.setMinIdle(3);
        // 最大活跃数
        int maxActive = DataUtil.toInt(p.getProperty("jdbc." + name + ".maxActive", "20"));
        ds.setMaxActive(maxActive);
        // slave
        ds.setDefaultReadOnly(Boolean.parseBoolean(p.getProperty("jdbc." + name + ".slave")));

        ds.setRemoveAbandoned(true); //是否自动回收超时连接
        ds.setRemoveAbandonedTimeout(300); //单位秒
        ds.setLogAbandoned(true); //自动中断写日志
        ds.setTestOnBorrow(false);
        ds.setTestOnReturn(false);

        ds.setTestWhileIdle(true); //指明连接是否被空闲连接回收
        ds.setTimeBetweenEvictionRunsMillis(3000); //在空闲连接回收器线程运行期间休眠的时间值,以毫秒为单位.

        ds.setMinEvictableIdleTimeMillis(300000); //连接池中连接可空闲的时间,毫秒


        try {
            ds.setFilters("mergeStat,wall");
        } catch (SQLException e) {
            e.printStackTrace();
        }
        ds.setMaxWait(60000);
        ds.setPoolPreparedStatements(true);
        ds.setMaxPoolPreparedStatementPerConnectionSize(20);
        return ds;
    }
}
