package jmind.core.jdbc;

import javax.sql.DataSource;

import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;

public class DbcpBasicDataSource  extends DataSourceFactory{

    @Override
    public DataSource getSource(String name, IProperties p) {
        /**
         * <property name="driverClassName" value="com.mysql.jdbc.Driver" />
        <property name="url" value="${jdbc.url}" />
        <property name="username" value="${jdbc.user}" />
        <property name="password" value="${jdbc.password}" />
        <property name="maxIdle" value="10" />
        <!-- 300秒回收不用的连接 -->
        <property name="removeAbandoned" value="true" />
        <property name="removeAbandonedTimeout" value="300" />
        <!-- MySQL8小时问题 -->
        <property name="validationQuery" value="SELECT 1" />
        <property name="testOnBorrow" value="false" />
        <property name="testOnReturn" value="false" />
        <property name="testWhileIdle" value="true" />
        <property name="timeBetweenEvictionRunsMillis" value="300000" />
        <property name="numTestsPerEvictionRun" value="3" />
        <property name="minEvictableIdleTimeMillis" value="1800000" />
        
         */
        String url = p.getProperty("jdbc." + name + ".url");
        System.out.println("jdbc." + name + ".url=" + url);
        if (DataUtil.isEmpty(url)) {
            return null;
        }
        org.apache.commons.dbcp.BasicDataSource ds = new org.apache.commons.dbcp.BasicDataSource();
        ds.setUrl(url);
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        if (url.startsWith("jdbc:oracle")) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
            ds.setValidationQuery("SELECT * FROM DUAL");
        } else if (url.startsWith("jdbc:sqlserver")) {
            driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

        } else {
            ds.setValidationQuery("SELECT 1");
        }
        ds.setDriverClassName(driverClassName);
        ds.setUsername(p.getProperty("jdbc." + name + ".username"));
        ds.setPassword(p.getProperty("jdbc." + name + ".password"));
        // 最大空闲数
        ds.setMaxIdle(DataUtil.toInt(p.getProperty("jdbc." + name + ".maxIdle", "10")));
        // 最大活跃数
        int maxActive = DataUtil.toInt(p.getProperty("jdbc." + name + ".maxActive", "20"));
        ds.setMaxActive(maxActive);
        // slave
        ds.setDefaultReadOnly(Boolean.parseBoolean(p.getProperty("jdbc." + name + ".slave")));

        ds.setRemoveAbandoned(true); //是否自动回收超时连接  
        ds.setRemoveAbandonedTimeout(300); //单位秒
        ds.setLogAbandoned(true); //自动中断写日志
        ds.setTestOnBorrow(false);
        ds.setTestOnReturn(false);

        ds.setTestWhileIdle(true); //指明连接是否被空闲连接回收
        ds.setTimeBetweenEvictionRunsMillis(300000); //在空闲连接回收器线程运行期间休眠的时间值,以毫秒为单位.
        ds.setNumTestsPerEvictionRun(3); //在每次空闲连接回收器线程(如果有)运行时检查的连接数量
        ds.setMinEvictableIdleTimeMillis(1800000); //连接池中连接可空闲的时间,毫秒
        return ds;

    }

}
