package jmind.core.jdbc;

import javax.sql.DataSource;

import jmind.base.lang.IProperties;

public abstract class DataSourceFactory {

    public abstract DataSource getSource(String name,IProperties p);

    public static DataSourceFactory  createFactory(String name) {
         // p.getProperty("jdbc." + name + ".datasource")
        if ("hikari".equalsIgnoreCase(name)) {
            return new HikariDataSource();
        } else if("dbcp".equalsIgnoreCase(name)){
            return new DbcpBasicDataSource();
        }else{
            return new DruidDataSource();
        }

    }

}
