package jmind.core.dubbo.callback;

import jmind.core.dubbo.cache.LocalCache;
import jmind.core.dubbo.cache.LocalCacheManager;
import jmind.core.dubbo.pojo.BusEvent;
import jmind.core.log.LogUtil;

public class LocalCacheCallback implements Callback {

    public boolean doIt(BusEvent event) {
        LocalCache xCache = LocalCacheManager.getInstance().getResource(event.getVal());
        if (event.getData() == null) {
            xCache.clear();
        } else {
            boolean b = xCache.delete(event.getData());
            LogUtil.debug("LocalCacheCallback event={},{}", event, b);
        }

        return true;
    }

}
