package jmind.core.dubbo.callback;

import java.util.Set;

import jmind.core.dubbo.pojo.BusEvent;

/**
 * callback 与busService 区别，callback直接调用，不启动线程
 * @author xieweibo
 * @date 2016年6月20日
 */
public interface ICallbackService {
    /**
     * 注册一个事件
     * @param key
     * @param callback
     */
    void addListener(String key, Callback callback);

    /**
     * 发送一个事件.后端立即执行
     * @param event
     */
    void addEvent(BusEvent event);

    Set<String> getRemotes();

}
