package jmind.core.dubbo.cache;

import com.alibaba.dubbo.cache.Cache;
import com.alibaba.dubbo.cache.CacheFactory;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import jmind.core.manager.AbstractManager;

public class XCacheFactory extends AbstractManager<Cache> implements CacheFactory {

  //  private final ICache cache ;// new RedisCache();

    public Cache getCache(URL url) {
        String prefix = url.getPath() + "." + url.getParameter(Constants.METHOD_KEY);
        return getResource(prefix);
    }

    @Override
    public XCache create(String name) {
        return new XCache(name, null);
    }

    @Override
    public void releaseResource() {

    }

    @Override
    public Cache getCache(URL url, Invocation invocation) {
        return getCache(url);
    }
}
