package jmind.core.dubbo.cache;

import com.alibaba.dubbo.cache.Cache;
import jmind.base.cache.ICache;

public class XCache implements Cache {

    private final ICache cache;
    private final String prefix;

    public XCache(String prefix, ICache cache) {
        this.prefix = prefix;
        this.cache = cache;
    }

    public void put(Object key, Object value) {
        cache.set(prefix + key, value);

    }

    public Object get(Object key) {
        return cache.get(key.toString());
    }

}
