package jmind.core.dubbo.cache;

import jmind.core.manager.AbstractManager;

public class LocalCacheManager extends AbstractManager<LocalCache> {

    private static volatile LocalCacheManager manager;

    public static LocalCacheManager getInstance() {
        if (manager == null) {
            synchronized (LocalCacheManager.class) {
                if (manager == null) {
                    manager = new LocalCacheManager();
                }
            }
        }
        return manager;
    }

    @Override
    public LocalCache create(String name) {
        return new LocalCache();
    }

    @Override
    public void releaseResource() {

    }

}
