package jmind.core.dubbo.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import com.alibaba.dubbo.cache.Cache;

public class LocalCache implements Cache {

    private final ConcurrentMap<Object, Object> cache = new ConcurrentHashMap<Object, Object>();

    public void put(Object key, Object value) {
        if (value != null)
            cache.put(key, value);

    }

    public Object get(Object key) {
        return cache.get(key);
    }

    public boolean delete(Object key) {
        return cache.remove(key) != null;
    }

    public void clear() {
        cache.clear();
    }

    public Map<Object, Object> getCache() {
        return cache;
    }

}
