package jmind.core.cache.xmemcached;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;

import jmind.base.lang.ExpireRecord;
import jmind.base.util.GlobalConstants;
import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.Counter;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.impl.ReconnectRequest;
import net.rubyeye.xmemcached.networking.Connector;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.CompressionMode;
import net.rubyeye.xmemcached.utils.Protocol;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author wbxie
 * 2013-7-18
 */
@SuppressWarnings("deprecation")
public class MemcachedImpl implements Memcached {

    private final MemcachedClient delegate;
    private final ExpireRecord record = new ExpireRecord(GlobalConstants.MINUTE * 5);
    private final Logger logger = LoggerFactory.getLogger(getClass());

    public MemcachedImpl(final MemcachedClient client) {
        this.delegate = client;
    }

    @Override
    public long getConnectTimeout() {
        return this.delegate.getConnectTimeout();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public ExpireRecord getException() {
        return record;
    }

    private  void err(String key, Exception e) {
        logger.warn(key, e);
        record.ExceptionRecord(e, key);

    }

    @Override
    public <T> T get(final String key, final long timeout, final Transcoder<T> transcoder) {
        try {
            return this.delegate.get(key, this.transcoder(transcoder));
        } catch (final Exception e) {
            err(key, e);
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T get(final String key, final long timeout) {
        try {
            return (T) this.delegate.get(key, timeout);
        } catch (final Exception e) {
            err(key, e);
            return null;
        }
    }

    @Override
    public <T> T get(final String key, final Transcoder<T> transcoder) {
        try {
            return this.delegate.get(key, this.transcoder(transcoder));
        } catch (final Exception e) {
            err(key, e);
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T get(final String key) {
        try {
            return (T) this.delegate.get(key);
        } catch (final Exception e) {
            err(key, e);
            return null;
        }
    }

    @Override
    public Map<String, ?> getMulti(Collection<String> keys) {
        return get(keys);
    }

    @Override
    public Object getCache() {
        return null;
    }

    @Override
    public void clear() {

    }

    @Override
    public <T> Map<String, T> get(final Collection<String> keyCollections, final long opTimeout,
            final Transcoder<T> transcoder) {
        try {
            return this.delegate.get(keyCollections, opTimeout, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> get(final Collection<String> keyCollections, final Transcoder<T> transcoder) {
        try {
            return this.delegate.get(keyCollections, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> get(final Collection<String> keyCollections) {
        try {
            return this.delegate.get(keyCollections);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> get(final Collection<String> keyCollections, final long timeout) {
        try {
            return this.delegate.get(keyCollections, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> boolean set(final String key, final int exp, final T value, final Transcoder<T> transcoder,
            final long timeout) {
        try {
            if (value == null)
                return false;
            return this.delegate.set(key, exp, value, this.transcoder(transcoder), timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean set(final String key, final int exp, final Object value) {

        try {
            if (value == null)
                return false;
            return this.delegate.set(key, exp, value);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean exists(String key) {
        return false;
    }

    @Override
    public boolean set(final String key, final Object value) {
        return set(key, GlobalConstants.DAY * 30, value);
    }

    @Override
    public boolean set(final String key, final int exp, final Object value, final long timeout) {
        try {
            if (value == null)
                return false;
            return this.delegate.set(key, exp, value, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean set(final String key, final int exp, final T value, final Transcoder<T> transcoder) {
        try {
            if (value == null)
                return false;
            return this.delegate.set(key, exp, value, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public void setWithNoReply(final String key, final int exp, final Object value) {
        try {
            this.delegate.setWithNoReply(key, exp, value);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> void setWithNoReply(final String key, final int exp, final T value, final Transcoder<T> transcoder) {
        try {
            this.delegate.setWithNoReply(key, exp, value, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> boolean add(final String key, final int exp, final T value, final Transcoder<T> transcoder,
            final long timeout) {
        try {
            return this.delegate.add(key, exp, value, this.transcoder(transcoder), timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean add(final String key, final int exp, final Object value) {
        try {
            return this.delegate.add(key, exp, value);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean add(final String key, final int exp, final Object value, final long timeout) {
        try {
            return this.delegate.add(key, exp, value, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean add(final String key, final int exp, final T value, final Transcoder<T> transcoder) {
        try {
            return this.delegate.add(key, exp, value, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public void addWithNoReply(final String key, final int exp, final Object value) {
        try {
            this.delegate.addWithNoReply(key, exp, value);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> void addWithNoReply(final String key, final int exp, final T value, final Transcoder<T> transcoder) {
        try {
            this.delegate.addWithNoReply(key, exp, value, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> boolean replace(final String key, final int exp, final T value, final Transcoder<T> transcoder,
            final long timeout) {
        try {
            return this.delegate.replace(key, exp, value, this.transcoder(transcoder), timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean replace(final String key, final int exp, final Object value) {
        try {
            return this.delegate.replace(key, exp, value);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean replace(final String key, final int exp, final Object value, final long timeout) {
        try {
            return this.delegate.replace(key, exp, value, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean replace(final String key, final int exp, final T value, final Transcoder<T> transcoder) {
        try {
            return this.delegate.replace(key, exp, value, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public void replaceWithNoReply(final String key, final int exp, final Object value) {
        try {
            this.delegate.replaceWithNoReply(key, exp, value);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> void replaceWithNoReply(final String key, final int exp, final T value, final Transcoder<T> transcoder) {
        try {
            this.delegate.replaceWithNoReply(key, exp, value, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public boolean append(final String key, final Object value) {
        try {
            return this.delegate.append(key, value);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean append(final String key, final Object value, final long timeout) {
        try {
            return this.delegate.append(key, value, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public void appendWithNoReply(final String key, final Object value) {
        try {
            this.delegate.appendWithNoReply(key, value);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public boolean prepend(final String key, final Object value) {
        try {
            return this.delegate.prepend(key, value);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean prepend(final String key, final Object value, final long timeout) {
        try {
            return this.delegate.prepend(key, value, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public void prependWithNoReply(final String key, final Object value) {
        try {
            this.delegate.prependWithNoReply(key, value);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public boolean cas(final String key, final int exp, final Object value, final long cas) {
        try {
            return this.delegate.cas(key, exp, value, cas);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final int exp, final T value, final Transcoder<T> transcoder,
            final long timeout, final long cas) {
        try {
            return this.delegate.cas(key, exp, value, this.transcoder(transcoder), timeout, cas);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean cas(final String key, final int exp, final Object value, final long timeout, final long cas) {
        try {
            return this.delegate.cas(key, exp, value, timeout, cas);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final int exp, final T value, final Transcoder<T> transcoder,
            final long cas) {
        try {
            return this.delegate.cas(key, exp, value, this.transcoder(transcoder), cas);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final int exp, final CASOperation<T> operation,
            final Transcoder<T> transcoder) {
        try {
            return this.delegate.cas(key, exp, operation, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final int exp, final GetsResponse<T> getsResponse,
            final CASOperation<T> operation, final Transcoder<T> transcoder) {
        try {
            return this.delegate.cas(key, exp, getsResponse, operation);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final int exp, final GetsResponse<T> getsResponse,
            final CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, exp, getsResponse, operation);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final GetsResponse<T> getsResponse, final CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, getsResponse, operation);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final int exp, final CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, exp, operation);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(final String key, final CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, operation);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public <T> void casWithNoReply(final String key, final GetsResponse<T> getsResponse, final CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, getsResponse, operation);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> void casWithNoReply(final String key, final int exp, final GetsResponse<T> getsResponse,
            final CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, exp, getsResponse, operation);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> void casWithNoReply(final String key, final int exp, final CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, exp, operation);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public <T> void casWithNoReply(final String key, final CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, operation);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public boolean delete(final String key, final long opTimeout) {
        try {
            return this.delegate.delete(key, opTimeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean touch(final String key, final int exp, final long opTimeout) {
        try {
            return this.delegate.touch(key, exp, opTimeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @Override
    public boolean touch(final String key, final int exp) {
        try {
            return this.delegate.touch(key, exp);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getAndTouch(final String key, final int newExp, final long opTimeout) {
        try {
            return (T) this.delegate.getAndTouch(key, newExp, opTimeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getAndTouch(final String key, final int newExp) {
        try {
            return (T) this.delegate.getAndTouch(key, newExp);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public Map<InetSocketAddress, String> getVersions() {
        try {
            return this.delegate.getVersions();
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public long incr(final String key, final long delta) {
        try {
            return this.delegate.incr(key, delta);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public long incr(final String key, final long delta, final long initValue) {
        try {
            return this.delegate.incr(key, delta, initValue);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public long incr(final String key, final long delta, final long initValue, final long timeout) {
        try {
            return this.delegate.incr(key, delta, initValue, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public long decr(final String key, final long delta) {
        try {
            return this.delegate.decr(key, delta);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public long decr(final String key, final long delta, final long initValue) {
        try {
            return this.delegate.decr(key, delta, initValue);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public long decr(final String key, final long delta, final long initValue, final long timeout) {
        try {
            return this.delegate.decr(key, delta, initValue, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStats(final long timeout) {
        try {
            return this.delegate.getStats(timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStats() {
        try {
            return this.delegate.getStats();
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStatsByItem(final String itemName) {
        try {
            return this.delegate.getStatsByItem(itemName);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public boolean delete(final String key) {
        try {
            return this.delegate.delete(key);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public Transcoder<?> getTranscoder() {
        return this.transcoder(this.delegate.getTranscoder());
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStatsByItem(final String itemName, final long timeout) {
        try {
            return this.delegate.getStatsByItem(itemName, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public long getOpTimeout() {
        return this.delegate.getOpTimeout();
    }

    @Override
    public Map<InetSocketAddress, String> getVersions(final long timeout) {
        try {
            return this.delegate.getVersions(timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public Collection<InetSocketAddress> getAvaliableServers() {
        return this.delegate.getAvaliableServers();
    }

    @Override
    public void deleteWithNoReply(final String key) {
        try {
            this.delegate.deleteWithNoReply(key);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public void incrWithNoReply(final String key, final long delta) {
        try {
            this.delegate.incrWithNoReply(key, delta);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public void decrWithNoReply(final String key, final long delta) {
        try {
            this.delegate.decrWithNoReply(key, delta);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public void flushAllWithNoReply(final int exptime) {
        try {
            this.delegate.flushAllWithNoReply(exptime);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public void flushAll(final int exptime, final long timeout) {
        try {
            this.delegate.flushAll(exptime, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public void flushAllWithNoReply(final InetSocketAddress address, final int exptime) {
        this.flushAllWithNoReply(address, exptime);
    }

    @Override
    public void flushAll(final InetSocketAddress address, final long timeout, final int exptime) {
        try {
            this.delegate.flushAll(address, timeout, exptime);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    @Override
    public long getHealSessionInterval() {
        return this.delegate.getHealSessionInterval();
    }

    @Override
    public Protocol getProtocol() {
        return this.delegate.getProtocol();
    }

    @Override
    public boolean isSanitizeKeys() {
        return this.delegate.isSanitizeKeys();
    }

    @Override
    public Counter getCounter(final String key) {
        return this.delegate.getCounter(key);
    }

    @Override
    public Counter getCounter(final String key, final long initialValue) {
        return this.delegate.getCounter(key, initialValue);
    }

    @Override
    public long decr(final String key, final long delta, final long initValue, final long timeout, final int exp) {
        try {
            return this.delegate.decr(key, delta, initValue, timeout, exp);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public long incr(final String key, final long delta, final long initValue, final long timeout, final int exp) {
        try {
            return this.delegate.incr(key, delta, initValue, timeout, exp);
        } catch (final Exception e) {
            logger.warn("", e);
            return 0;
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    protected void setMergeFactor(final int mergeFactor) {
        this.delegate.setMergeFactor(mergeFactor);
    }

    protected void setConnectTimeout(final long connectTimeout) {
        this.delegate.setConnectTimeout(connectTimeout);
    }

    protected Connector getConnector() {
        return this.delegate.getConnector();
    }

    protected void setOptimizeGet(final boolean optimizeGet) {
        this.delegate.setOptimizeGet(optimizeGet);
    }

    protected void setOptimizeMergeBuffer(final boolean optimizeMergeBuffer) {
        this.delegate.setOptimizeMergeBuffer(optimizeMergeBuffer);
    }

    protected void addServer(final String server, final int port) throws IOException {
        this.delegate.addServer(server, port);
    }

    protected void addServer(final InetSocketAddress inetSocketAddress) throws IOException {
        this.delegate.addServer(inetSocketAddress);
    }

    protected void addServer(final String hostList) throws IOException {
        this.delegate.addServer(hostList);
    }

    protected List<String> getServersDescription() {
        return this.delegate.getServersDescription();
    }

    protected void removeServer(final String hostList) {
        this.delegate.removeServer(hostList);
    }

    protected void setBufferAllocator(final BufferAllocator bufferAllocator) {
        this.delegate.setBufferAllocator(bufferAllocator);
    }

    protected <T> GetsResponse<T> gets(final String key, final long timeout, final Transcoder<T> transcoder) {
        try {
            return this.delegate.gets(key, timeout, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> GetsResponse<T> gets(final String key) {
        try {
            return this.delegate.gets(key);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> GetsResponse<T> gets(final String key, final long timeout) {
        try {
            return this.delegate.gets(key, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected <T> GetsResponse<T> gets(final String key, final Transcoder<?> transcoder) {
        try {
            return this.delegate.gets(key, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected <T> Map<String, GetsResponse<T>> gets(final Collection<String> keyCollections, final long opTime,
            final Transcoder<T> transcoder) {
        try {
            return this.delegate.gets(keyCollections, opTime, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> Map<String, GetsResponse<T>> gets(final Collection<String> keyCollections) {
        try {
            return this.delegate.gets(keyCollections);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    @Override
    public <T> Map<String, GetsResponse<T>> gets(final Collection<String> keyCollections, final long timeout) {
        try {
            return this.delegate.gets(keyCollections, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected <T> Map<String, GetsResponse<T>> gets(final Collection<String> keyCollections,
            final Transcoder<T> transcoder) {
        try {
            return this.delegate.gets(keyCollections, this.transcoder(transcoder));
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected boolean delete(final String key, final int time) {
        try {
            return this.delegate.delete(key, time);
        } catch (final Exception e) {
            logger.warn("", e);
            return false;
        }
    }

    protected void flushAll() {
        try {
            this.delegate.flushAll();
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void flushAllWithNoReply() {
        try {
            this.delegate.flushAllWithNoReply();
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void flushAll(final long timeout) {
        try {
            this.delegate.flushAll(timeout);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void flushAll(final InetSocketAddress address) {
        try {
            this.delegate.flushAll(address);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void flushAllWithNoReply(final InetSocketAddress address) {
        try {
            this.delegate.flushAllWithNoReply(address);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void flushAll(final InetSocketAddress address, final long timeout) {
        try {
            this.delegate.flushAll(address, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void flushAll(final String host) {
        try {
            this.delegate.flushAll(host);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected Map<String, String> stats(final InetSocketAddress address) {
        try {
            return this.delegate.stats(address);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected Map<String, String> stats(final InetSocketAddress address, final long timeout) {
        try {
            return this.delegate.stats(address, timeout);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected void setTranscoder(final Transcoder<?> transcoder) {
        this.delegate.setTranscoder(this.transcoder(transcoder));
    }

    protected void setOpTimeout(final long opTimeout) {
        this.delegate.setOpTimeout(opTimeout);
    }

    protected void addServer(final String server, final int port, final int weight) throws IOException {
        this.delegate.addServer(server, port, weight);
    }

    protected void addServer(final InetSocketAddress inetSocketAddress, final int weight) throws IOException {
        this.delegate.addServer(inetSocketAddress, weight);
    }

    protected void deleteWithNoReply(final String key, final int time) {
        try {
            this.delegate.deleteWithNoReply(key, time);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void setLoggingLevelVerbosity(final InetSocketAddress address, final int level) {
        try {
            this.delegate.setLoggingLevelVerbosity(address, level);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void setLoggingLevelVerbosityWithNoReply(final InetSocketAddress address, final int level) {
        try {
            this.delegate.setLoggingLevelVerbosityWithNoReply(address, level);
        } catch (final Exception e) {
            logger.warn("", e);
        }
    }

    protected void addStateListener(final MemcachedClientStateListener listener) {
        this.delegate.addStateListener(listener);
    }

    protected void removeStateListener(final MemcachedClientStateListener listener) {
        this.delegate.removeStateListener(listener);
    }

    protected Collection<MemcachedClientStateListener> getStateListeners() {
        return this.delegate.getStateListeners();
    }

    protected void setHealSessionInterval(final long healConnectionInterval) {
        this.delegate.setHealSessionInterval(healConnectionInterval);
    }

    protected void setPrimitiveAsString(final boolean primitiveAsString) {
        this.delegate.setPrimitiveAsString(primitiveAsString);
    }

    protected void setConnectionPoolSize(final int poolSize) {
        this.delegate.setConnectionPoolSize(poolSize);
    }

    protected void setEnableHeartBeat(final boolean enableHeartBeat) {
        this.delegate.setEnableHeartBeat(enableHeartBeat);
    }

    protected void setSanitizeKeys(final boolean sanitizeKey) {
        this.delegate.setSanitizeKeys(sanitizeKey);
    }

    protected KeyIterator getKeyIterator(final InetSocketAddress address) {
        try {
            return this.delegate.getKeyIterator(address);
        } catch (final Exception e) {
            logger.warn("", e);
            return null;
        }
    }

    protected void setAuthInfoMap(final Map<InetSocketAddress, AuthInfo> map) {
        this.delegate.setAuthInfoMap(map);
    }

    protected Map<InetSocketAddress, AuthInfo> getAuthInfoMap() {
        return this.delegate.getAuthInfoMap();
    }

    protected void setName(final String name) {
        this.delegate.setName(name);
    }

    protected Queue<ReconnectRequest> getReconnectRequestQueue() {
        return this.delegate.getReconnectRequestQueue();
    }

    protected void setFailureMode(final boolean failureMode) {
        this.delegate.setFailureMode(failureMode);
    }

    protected boolean isFailureMode() {
        return this.delegate.isFailureMode();
    }

    @Override
    protected void finalize() throws Throwable {
        System.out.println(this.getClass().getName() + " finalize");
        delegate.shutdown();
        super.finalize();
    }

    @SuppressWarnings("unchecked")
    private <T> Transcoder<T> transcoder(final net.rubyeye.xmemcached.transcoders.Transcoder<T> t) {
        if (this.delegate == null)
            return null;

        if (t instanceof Transcoder)
            return (Transcoder<T>) t;

        return new Transcoder<T>() {

            final net.rubyeye.xmemcached.transcoders.Transcoder<T> delegate = MemcachedImpl.this.delegate
                    .getTranscoder();

            @Override
            public byte[] encode(final T o) {
                return this.delegate.encode(o).getData();
            }

            @Override
            public T decode(final byte[] d) {
                final CachedData data = new CachedData();
                data.fillData(ByteBuffer.wrap(d), 0, d.length);
                return this.delegate.decode(data);
            }
        };
    }

    @SuppressWarnings("unchecked")
    private <T> net.rubyeye.xmemcached.transcoders.Transcoder<T> transcoder(final Transcoder<T> t) {
        if (t instanceof net.rubyeye.xmemcached.transcoders.Transcoder)
            return (net.rubyeye.xmemcached.transcoders.Transcoder<T>) t;

        return new net.rubyeye.xmemcached.transcoders.Transcoder<T>() {

            private boolean packZeros = true;
            private boolean primitiveAsString = false;

            @Override
            public CachedData encode(final T o) {
                final byte[] data = t.encode(o);

                final CachedData result = new CachedData();
                result.fillData(ByteBuffer.wrap(data), 0, data.length);
                return result;
            }

            @Override
            public T decode(final CachedData d) {
                try {
                    // CachedData未暴露data, 只好尝试获取其私有属性
                    final Field dataField = CachedData.class.getDeclaredField("data");
                    dataField.setAccessible(true);
                    return t.decode((byte[]) dataField.get(d));
                } catch (final Exception e) {
                    logger.error("", e);
                }
                return null;
            }

            @Override
            public void setPrimitiveAsString(final boolean primitiveAsString) {
                this.primitiveAsString = primitiveAsString;
            }

            @Override
            public void setPackZeros(final boolean packZeros) {
                this.packZeros = packZeros;
            }

            @Override
            public void setCompressionThreshold(final int to) {
                // do nothing
            }

            @Override
            public boolean isPrimitiveAsString() {
                return this.primitiveAsString;
            }

            @Override
            public boolean isPackZeros() {
                return this.packZeros;
            }

            @Override
            public void setCompressionMode(CompressionMode arg0) {

            }
        };
    }

}
