package jmind.core.cache.support;

import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentMap;

import com.google.common.cache.*;
import jmind.base.algo.atomic.StatsCounter;
import jmind.base.algo.atomic.StatsCounter.SCount;

import com.google.common.collect.Lists;

public class StatsCounterCache {

    final com.google.common.cache.Cache<String, StatsCounter> cache;
    public StatsCounterCache() {
        this(3000);
    }

    public StatsCounterCache(int maxSize) {
        cache = CacheBuilder.newBuilder().maximumSize(maxSize).softValues().build();
    }

    /**
            * 必须获得，没有new 一个
            * @param
            * @return
            */
    public StatsCounter mustGet(String k) {
        StatsCounter statsCounter =cache.getIfPresent(k);
        if (statsCounter == null) {
            synchronized (this) {
                statsCounter = cache.getIfPresent(k);
                if (statsCounter == null) {
                    statsCounter = new StatsCounter();
                    cache.put(k, statsCounter);
                }
            }
        }

        return statsCounter;
    }

    public List<SCount> stat() {
        ConcurrentMap<String, StatsCounter> map = this.cache.asMap();
        List<SCount> list = Lists.newArrayListWithExpectedSize(map.size());
        long sumSucc = 0, sumSuccTime = 0, sumException = 0, sumExcetionTime = 0, slowCount = 0;
        for (Entry<String, StatsCounter> entry : map.entrySet()) {
            SCount counter = entry.getValue().snapshot();
            counter.setKey(entry.getKey());
            list.add(counter);
            sumSucc += counter.getSuccessCount();
            sumSuccTime += counter.getTotalSuccessTime();
            sumException += counter.getExceptionCount();
            sumExcetionTime += counter.getTotalExceptionTime();
            slowCount += counter.getSlowCount();
        }
        SCount counter = new SCount();
        counter.setKey("total");
        counter.setSuccessCount(sumSucc);
        counter.setTotalSuccessTime(sumSuccTime);
        counter.setExceptionCount(sumException);
        counter.setTotalExceptionTime(sumExcetionTime);
        counter.setSlowCount(slowCount);
        list.add(counter);
        return list;
    }

}
