package jmind.core.cache.support;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

/**
 * @see org.springframework.cache.concurrent.ConcurrentMapCacheFactoryBean
 * @author wbxie
 * 2013-12-5
 */
public class SpringCacheFactoryBean implements FactoryBean<SpringCache>, BeanNameAware, InitializingBean {

    private String name = "";

    private SpringCache cache;

    /**
     * Specify the name of the cache.
     * <p>Default is "" (empty String).
     */
    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String beanName) {
        if (!StringUtils.hasLength(this.name)) {
            setName(beanName);
        }
    }

    public void afterPropertiesSet() {
        this.cache = new SpringCache(name);

    }

    public SpringCache getObject() {
        return this.cache;
    }

    public Class<?> getObjectType() {
        return SpringCache.class;
    }

    public boolean isSingleton() {
        return true;
    }

}
