package jmind.core.cache.support;

import com.google.common.collect.Maps;
import jmind.base.cache.ICache;
import jmind.base.cache.LocalCache;
import jmind.base.cache.MemCache;
import jmind.core.manager.XMemCacheManager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache {




    private Cache() {
    }

    public static Cache getCache() {
        return Nested.instance;
    }

    static class Nested {
        private static Cache instance = new Cache();
    }

    private final ICache guava = new GuavaCache(6000, 10, false);

    private final LocalCache PersistentCache = new LocalCache(
            new ConcurrentHashMap<String, Object>());


    public ICache getCache(ICache.Type type, String name) {
        switch (type) {
            case XMEM:
              return XMemCacheManager.getInstance().getResource(name);
            case GUAVA:
                return guava;
            case PERSISTENT:
                return PersistentCache;
            default:
                return guava;
        }
    }

    @SuppressWarnings("rawtypes")
    public Map<String, Object> stats(MemCache cache) {
        Map<String, Object> map = Maps.newHashMap();
        Object obj = cache.getCache();
        if (obj instanceof com.google.common.cache.Cache) {
            com.google.common.cache.Cache c = (com.google.common.cache.Cache) obj;
            map.put("size", c.size());
            map.put("stats", c.stats());
        } else if (obj instanceof Map) {
            Map c = (Map) obj;
            map.put("size", c.size());
        }
        return map;
    }

}
