package jmind.core.aspect;

/**
 * Created by weibo.xwb on 2017/9/19.
 */

import jmind.base.cache.ICache;
import jmind.base.util.DataUtil;
import jmind.base.util.GlobalConstants;
import jmind.base.annotation.CacheMonitor;
import jmind.core.support.MethodSupport;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;

/**
 * @author wbxie
 * @CacheMonitor( key = "'user",exp=3600)
 * @CacheMonitor(prefix ="user", exp = GlobalConstants.HOUR, spel = "mac")
 * key 用做前缀+ 方法参数值
 * @Component
 * @Aspect 好像什么时候都需要打这个标签
 * 2013-12-4
 */
 //  @Aspect  这个在子类写
public abstract class AbstractCacheAspect {

    protected abstract ICache getCache(ICache.Type type, String name);


    @Pointcut("@annotation(jmind.base.annotation.CacheMonitor)")
    public void exe2() {
    }

    @Around("exe2()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {


        final CacheMonitor m = JoinPoints.getAnnotation(pjp, CacheMonitor.class);
        // MethodSignature signature = (MethodSignature) pjp.getSignature();
        // System.out.println(signature.getDeclaringTypeName() + "&" + signature.getName() + "&"
        //         + signature.toLongString() + "&" + signature.toShortString() + "&" + signature.getDeclaringType());
        //  System.out.println(signature.getMethod().getName()+"%"+signature.getReturnType());


        // key 用做前缀 ,当spel不为空时，取第一个对象的属性值
        final String key = m.spel().isEmpty() ? DataUtil.composeKey(m.prefix(), pjp.getArgs()) : m.prefix()
                + GlobalConstants.DASH + MethodSupport.getProperty(pjp.getArgs()[0], m.spel());

        ICache cache =getCache(m.type(), m.name());
        //添加参数值 做为key
        if (m.remove()) {
            Object object = pjp.proceed();
            cache.delete(key);
            return object;
        }
        return cache.computeIfAbsent(key, m.exp(), k -> {
            try {
                System.err.println("do proceed");
                return pjp.proceed();
            } catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        });


    }




}

