/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.taglib;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import jmind.base.lang.Page;
import jmind.base.util.RequestUtil;

public class PageTag
extends TagSupport {
    private static final int number = 10;
    private Page<?> page;

    public Page<?> getPage() {
        return this.page;
    }

    public void setPage(Page<?> page) {
        this.page = page;
    }

    public int doStartTag() throws JspException {
        try {
            if (this.page.getPagecount() > 1) {
                String tags_html = this.httpUri();
                this.pageContext.getOut().print(tags_html);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        this.page = null;
        return super.doEndTag();
    }

    String httpUri() {
        StringBuilder html = new StringBuilder();
        html.append("<div class='paddinttop page'>");
        if (this.page.getPage() > 1) {
            html.append("<a href='" + this.getPageUrl(this.page.getPrev()) + "' class='prev'><em>&laquo;</em></a>");
        }
        if (this.page.getPage() <= 1) {
            html.append("<span class='prev'><em>&laquo;</em></span>");
        }
        boolean isNext = true;
        if (this.page.getPagecount() < 23) {
            for (int i = 1; i <= this.page.getPagecount(); ++i) {
                if (this.page.getPage() == i) {
                    html.append("<a class='default' href='javascript:;'><em>" + i + "</em></a>");
                    continue;
                }
                html.append("<a href='" + this.getPageUrl(i) + "'><em>" + i + "</em></a>");
            }
            isNext = false;
        }
        if (isNext) {
            int min = 0;
            int max = 0;
            min = this.page.getPage() - 10 > 0 ? this.page.getPage() - 10 : 1;
            max = this.page.getPage() + 10 < this.page.getPagecount() ? this.page.getPage() + 10 : this.page.getPagecount();
            if (this.page.getPage() <= 9) {
                max = 11;
            } else {
                if (this.page.getPage() - 1 < 10) {
                    max += 10;
                }
                if (this.page.getPage() - 1 == 10) {
                    max += 9;
                }
            }
            if (this.page.getPagecount() == this.page.getPage()) {
                min -= 10;
            }
            if (this.page.getPagecount() - this.page.getPage() < 10) {
                min = min - (this.page.getPagecount() - this.page.getPage()) - 1;
            }
            if (this.page.getPagecount() - this.page.getPage() == 10) {
                min -= 9;
            }
            if (min > 1) {
                html.append("<a href='" + this.getPageUrl(1) + "'><em>1</em></a>");
            }
            if (min - 1 > 1) {
                html.append("&nbsp;...&nbsp;");
            }
            for (int i = min; i <= max; ++i) {
                if (this.page.getPage() == i) {
                    html.append("<a class='default' href='javascript:;'><em>" + i + "</em></a>");
                    continue;
                }
                html.append("<a href='" + this.getPageUrl(i) + "'><em>" + i + "</em></a>");
            }
            if (max + 1 < this.page.getPagecount()) {
                html.append("&nbsp;...&nbsp;");
            }
            if (max < this.page.getPagecount()) {
                html.append("<a href='" + this.getPageUrl(this.page.getPagecount()) + "'><em>" + this.page.getPagecount() + "</em></a>");
            }
        }
        if (this.page.getPage() < this.page.getPagecount()) {
            html.append("<a href='" + this.getPageUrl(this.page.getNext()) + "' class='next'><em>&raquo;</em></a>");
        }
        if (this.page.getPage() >= this.page.getPagecount()) {
            html.append("<span class='next'><em>&raquo;</em></span>");
        }
        html.append("</div>");
        return html.toString();
    }

    private String getPageUrl(int curpage) {
        Map query = this.page.getQuery();
        query.put("page", String.valueOf(curpage));
        query.put("count", String.valueOf(this.page.getCount()));
        return this.page.getUri() + "?" + RequestUtil.toQueryString((Map)query);
    }
}

