/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinYinUtil {
    private static final Logger log = LoggerFactory.getLogger(PinYinUtil.class);
    private static final HanyuPinyinOutputFormat FORMAT = new HanyuPinyinOutputFormat();

    private static String[][] getPinyinRaw(String src) {
        if (src != null && !src.trim().isEmpty()) {
            char[] chars = src.toCharArray();
            String[][] result = new String[src.length()][];
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (PinYinUtil.isChineseCharacter(c)) {
                    try {
                        result[i] = PinyinHelper.toHanyuPinyinStringArray((char)chars[i], (HanyuPinyinOutputFormat)FORMAT);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        log.warn("bad hanyu pinyin output format combination", (Throwable)e);
                    }
                    continue;
                }
                result[i] = PinYinUtil.isLetters(c) ? new String[]{String.valueOf(chars[i])} : new String[]{""};
            }
            return result;
        }
        return new String[0][];
    }

    public static String getPinyin(String src) {
        return PinYinUtil.getPinyin(src, "");
    }

    public static String getPinyin(String src, String sign) {
        String[][] pinyinRaw;
        StringBuilder result = new StringBuilder();
        for (String[] pinyin : pinyinRaw = PinYinUtil.getPinyinRaw(src)) {
            if (result.length() > 0) {
                result.append(sign);
            }
            result.append(pinyin[0]);
        }
        return result.toString();
    }

    public static boolean isChineseCharacter(char c) {
        return String.valueOf(c).matches("[\\u4E00-\\u9FA5]+");
    }

    private static boolean isLetters(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static void main(String[] args) {
        String src = "\u50e7";
        System.out.println(PinYinUtil.getPinyin("\u50e7"));
    }

    static {
        FORMAT.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        FORMAT.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        FORMAT.setVCharType(HanyuPinyinVCharType.WITH_V);
    }
}

