/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public abstract class HTMLUtil {
    private static final Whitelist whiteimg = new Whitelist().addTags(new String[]{"div", "span", "br", "p", "i", "b", "em", "strong", "img"}).addAttributes("div", new String[]{"class"}).addAttributes("span", new String[]{"class", "name"}).addAttributes("i", new String[]{"class"}).addAttributes("img", new String[]{"src", "alt"}).addProtocols("img", "src", new String[]{"http"});
    private static final Whitelist whitelist = new Whitelist().addTags(new String[]{"div", "span", "br", "p", "i", "b", "em", "u", "strong", "font"});
    private static final Whitelist onlyImg = new Whitelist().addTags(new String[]{"img"}).addAttributes("img", new String[]{"src", "border"});
    private static final String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static final String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
    private static final String regEx_html = "<[^>]+>";

    public static String replaceQuotation(String body) {
        return body.replace("\"", "&#34;").replace("'", "&#39;");
    }

    public static String replaceN(String body) {
        return body.replace("\n", "<br/>");
    }

    public static String relaxed(String body) {
        return Jsoup.clean((String)body, (Whitelist)Whitelist.relaxed());
    }

    public static String basic(String body) {
        return Jsoup.clean((String)body, (Whitelist)Whitelist.basic());
    }

    public static String clean(String body) {
        return Jsoup.clean((String)body, (Whitelist)whitelist);
    }

    public static String cleanAll(String body) {
        return Jsoup.clean((String)body, (Whitelist)Whitelist.none());
    }

    public static String onlyImg(String body) {
        return Jsoup.clean((String)body, (Whitelist)onlyImg);
    }

    public static String baiscWithImg(String body) {
        return Jsoup.clean((String)body, (Whitelist)whiteimg);
    }

    public static String getFlashContent(String flashUrl, int width, int height) {
        return "<embed src='" + flashUrl + "' wmode='transparent' quality='high' width='" + width + "' height=" + height + " align='middle'  type='application/x-shockwave-flash'></embed>";
    }

    public static String decodeHTML(String InputString) {
        String OutputString = null;
        if (InputString == null) {
            return "";
        }
        OutputString = new String(InputString);
        OutputString = OutputString.replace("&lt;", "<");
        OutputString = OutputString.replace("&gt;", ">");
        OutputString = OutputString.replace("\n", "<br/>");
        OutputString = OutputString.replace("&amp;", "&");
        OutputString = OutputString.replace("&#35;", "#");
        return OutputString;
    }

    public static String encodeHTML(String string) {
        if (string == null) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '#': {
                    sb.append("&#35;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String Html2Text(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        try {
            Pattern p_script = Pattern.compile(regEx_script, 2);
            Matcher m_script = p_script.matcher(htmlStr);
            htmlStr = m_script.replaceAll("");
            Pattern p_style = Pattern.compile(regEx_style, 2);
            Matcher m_style = p_style.matcher(htmlStr);
            htmlStr = m_style.replaceAll("");
            Pattern p_html = Pattern.compile(regEx_html, 2);
            Matcher m_html = p_html.matcher(htmlStr);
            textStr = htmlStr = m_html.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }
        return textStr;
    }

    public static void main(String[] args) {
        String content = "sdfd wa$&ve  d%d\njj\n\ndd \"s";
        content = HTMLUtil.cleanAll(content);
        System.out.println(content);
    }
}

