/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jmind.base.util.DataUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DocumentUtil {
    private static Map<String, Document> map = new ConcurrentHashMap<String, Document>();

    public static Document getDoc(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        Document doc = DocumentUtil.initDoc(name);
        map.put(name, doc);
        return doc;
    }

    private static Document initDoc(String name) {
        try {
            return Jsoup.parse((InputStream)DocumentUtil.class.getClassLoader().getResourceAsStream(name), (String)"UTF-8", (String)"");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getTagValues(String xml, String tag) {
        if (DataUtil.isEmpty((String)xml)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        Elements elements = Jsoup.parse((String)xml).select(tag);
        for (Element ele : elements) {
            list.add(ele.text());
        }
        return list;
    }

    public static String getTagValue(String xml, String tag) {
        if (DataUtil.isEmpty((String)xml)) {
            return "";
        }
        return Jsoup.parseBodyFragment((String)xml).select(tag).text();
    }

    public static void main(String[] args) {
        String values = DocumentUtil.getTagValue("<a><b>sds</b><d>sd</d></a>", "a >b");
        System.out.println(values);
    }
}

