/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jmind.base.util.DataUtil;
import jmind.core.log.LogUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.util.NumberUtils;

public class Collections {
    public static <T extends Number> List<T> asList(String str, String separator, Class<T> clazz) {
        if (DataUtil.isEmpty((String)str)) {
            return java.util.Collections.emptyList();
        }
        LinkedList list = new LinkedList();
        Collections.asCollection(str, separator, clazz, list);
        return list;
    }

    public static <T extends Number> Set<T> asSet(String str, String separator, Class<T> clazz) {
        if (DataUtil.isEmpty((String)str)) {
            return java.util.Collections.emptySet();
        }
        HashSet list = new HashSet();
        Collections.asCollection(str, separator, clazz, list);
        return list;
    }

    public static <T extends Number> Collection<T> asCollection(String str, String separator, Class<T> clazz, Collection<T> list) {
        if (separator.length() > 1) {
            String[] split;
            for (String s : split = str.split(separator)) {
                if ((s = s.trim()).isEmpty()) continue;
                list.add(NumberUtils.parseNumber((String)s, clazz));
            }
        } else {
            StringTokenizer token = new StringTokenizer(str, separator);
            while (token.hasMoreTokens()) {
                list.add(NumberUtils.parseNumber((String)token.nextToken(), clazz));
            }
        }
        return list;
    }

    public static <T extends Number> List<T> toNumberList(List<String> array, final Class<T> clazz) {
        return Lists.transform(array, (Function)new Function<String, T>(){

            public T apply(String input) {
                return NumberUtils.parseNumber((String)input, (Class)clazz);
            }
        });
    }

    public static <T> List<T> getPropertys(Collection<?> list, String name) {
        ArrayList a = Lists.newArrayList();
        try {
            for (Object obj : list) {
                Object object = PropertyUtils.getProperty(obj, (String)name);
                a.add(object);
            }
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
        return a;
    }

    public static <A, B> Map<A, B> uniqueIndex(List<B> list, final String name) {
        return Maps.uniqueIndex(list, (Function)new Function<B, A>(){

            public A apply(B obj) {
                try {
                    return PropertyUtils.getProperty(obj, (String)name);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }
}

