/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ChineseConverter {
    private final Properties charMap = new Properties();
    private final Set<String> conflictingSets = new HashSet<String>();
    private static final ChineseConverter[] converters = new ChineseConverter[2];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ChineseConverter getInstance(Chinese chinese) {
        int converterType = chinese.ordinal();
        if (converters[converterType] != null) return converters[converterType];
        Class<ChineseConverter> clazz = ChineseConverter.class;
        synchronized (ChineseConverter.class) {
            if (converters[converterType] != null) return converters[converterType];
            ChineseConverter.converters[converterType] = new ChineseConverter(chinese.name() + "-chinese.properties");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return converters[converterType];
        }
    }

    public static String convert(String text, Chinese converterType) {
        ChineseConverter instance = ChineseConverter.getInstance(converterType);
        return instance.convert(text);
    }

    private String convert(String in) {
        StringBuilder outString = new StringBuilder();
        StringBuilder stackString = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            String key = "" + c;
            stackString.append(key);
            if (this.conflictingSets.contains(stackString.toString())) continue;
            if (this.charMap.containsKey(stackString.toString())) {
                outString.append(this.charMap.get(stackString.toString()));
                stackString.setLength(0);
                continue;
            }
            CharSequence sequence = stackString.subSequence(0, stackString.length() - 1);
            stackString.delete(0, stackString.length() - 1);
            this.flushStack(outString, new StringBuilder(sequence));
        }
        this.flushStack(outString, stackString);
        return outString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChineseConverter(String propertyFile) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(propertyFile);
        if (in != null) {
            try {
                this.charMap.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("ZHConverter  in is null  " + propertyFile);
        }
        this.initializeHelper();
    }

    private void initializeHelper() {
        HashMap<String, Integer> stringPossibilities = new HashMap<String, Integer>();
        for (String string : this.charMap.keySet()) {
            if (string.length() < 1) continue;
            for (int i = 0; i < string.length(); ++i) {
                String keySubstring = string.substring(0, i + 1);
                if (stringPossibilities.containsKey(keySubstring)) {
                    Integer integer = (Integer)stringPossibilities.get(keySubstring);
                    stringPossibilities.put(keySubstring, new Integer(integer + 1));
                    continue;
                }
                stringPossibilities.put(keySubstring, new Integer(1));
            }
        }
        for (String string : stringPossibilities.keySet()) {
            if ((Integer)stringPossibilities.get(string) <= 1) continue;
            this.conflictingSets.add(string);
        }
    }

    private void flushStack(StringBuilder outString, StringBuilder stackString) {
        while (stackString.length() > 0) {
            if (this.charMap.containsKey(stackString.toString())) {
                outString.append(this.charMap.get(stackString.toString()));
                stackString.setLength(0);
                continue;
            }
            outString.append("" + stackString.charAt(0));
            stackString.delete(0, 1);
        }
    }

    public static enum Chinese {
        simplified,
        traditional;

    }
}

