/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Apns {
    protected static Logger log = LoggerFactory.getLogger(Apns.class);

    public void sendpush(List<String> tokens, String path, String password, String message, Integer badge, boolean sendCount) {
        try {
            Object device;
            PushNotificationPayload payLoad = PushNotificationPayload.fromJSON((String)message);
            payLoad.addBadge(badge.intValue());
            payLoad.addSound("default");
            PushNotificationManager pushManager = new PushNotificationManager();
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)path, password, true));
            PushedNotifications notifications = new ArrayList();
            if (sendCount) {
                log.debug("--------------------------apple \u63a8\u9001 \u5355-------");
                device = new BasicDevice();
                device.setToken(tokens.get(0).replace(" ", "").trim());
                PushedNotification notification = pushManager.sendNotification((Device)device, (Payload)payLoad, true);
                notifications.add(notification);
            } else {
                log.debug("--------------------------apple \u63a8\u9001 \u7fa4-------");
                device = new ArrayList();
                for (String token : tokens) {
                    device.add(new BasicDevice(token.replace(" ", "").trim()));
                }
                notifications = pushManager.sendNotifications((Payload)payLoad, (List)device);
            }
            List failedNotifications = PushedNotification.findFailedNotifications((List)notifications);
            List successfulNotifications = PushedNotification.findSuccessfulNotifications((List)notifications);
            int failed = failedNotifications.size();
            int successful = successfulNotifications.size();
            if (successful > 0 && failed == 0) {
                log.debug("-----All notifications pushed \u6210\u529f (" + successfulNotifications.size() + "):");
            } else if (successful == 0 && failed > 0) {
                log.debug("-----All notifications \u5931\u8d25 (" + failedNotifications.size() + "):");
            } else if (successful == 0 && failed == 0) {
                System.out.println("No notifications could be sent, probably because of a critical error");
            } else {
                log.debug("------Some notifications \u5931\u8d25 (" + failedNotifications.size() + "):");
                log.debug("------Others \u6210\u529f (" + successfulNotifications.size() + "):");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean sendpush(String token, String path, String password, String message, Integer badge, boolean production, Map<String, String> param) {
        try {
            PushNotificationPayload payLoad = PushNotificationPayload.combined((String)message, (int)badge, (String)"default");
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    payLoad.addCustomDictionary(entry.getKey(), entry.getValue());
                }
            }
            PushNotificationManager pushManager = new PushNotificationManager();
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)path, password, production));
            BasicDevice device = new BasicDevice(token.replace(" ", "").trim());
            PushedNotification notification = pushManager.sendNotification((Device)device, (Payload)payLoad, true);
            if (notification.getException() != null) {
                notification.getException().printStackTrace();
            }
            return notification.isSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void sendpushs(List<String> tokens, String path, String password, String message, Integer badge, boolean production) {
        try {
            PushNotificationPayload payLoad = PushNotificationPayload.combined((String)message, (int)badge, (String)"default");
            PushNotificationManager pushManager = new PushNotificationManager();
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)path, password, production));
            PushedNotifications notifications = new ArrayList();
            ArrayList<BasicDevice> device = new ArrayList<BasicDevice>();
            for (String token : tokens) {
                device.add(new BasicDevice(token.replace(" ", "").trim()));
            }
            notifications = pushManager.sendNotifications((Payload)payLoad, device);
            List failedNotifications = PushedNotification.findFailedNotifications((List)notifications);
            List successfulNotifications = PushedNotification.findSuccessfulNotifications((List)notifications);
            int failed = failedNotifications.size();
            int successful = successfulNotifications.size();
            if (successful > 0 && failed == 0) {
                log.debug("-----All notifications pushed \u6210\u529f (" + successfulNotifications.size() + "):");
            } else if (successful == 0 && failed > 0) {
                log.debug("-----All notifications \u5931\u8d25 (" + failedNotifications.size() + "):");
            } else if (successful == 0 && failed == 0) {
                System.out.println("No notifications could be sent, probably because of a critical error");
            } else {
                log.debug("------Some notifications \u5931\u8d25 (" + failedNotifications.size() + "):");
                log.debug("------Others \u6210\u529f (" + successfulNotifications.size() + "):");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean production = true;
        String token = "8928a658 15d08d45 5914840e c017b82c 6af9e8dd b4fba1aa 897be7c3 d49c4a2d";
        String path = "D:/d/workspace/im20/sc-ppg/src/main/resources/" + (production ? "pro.p12" : "dev.p12");
        String password = "1234567890";
        String message = "\u4eb2\uff0c\u65b0\u6d88\u606f";
        int badge = 1;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "1");
        map.put("tagId", "1234");
        boolean b = Apns.sendpush(token, path, password, message, badge, production, map);
        System.out.println(b);
    }
}

