/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmind.base.lang.Page;
import jmind.base.util.DataUtil;
import jmind.base.util.FileUtil;
import jmind.base.util.IpUtil;
import jmind.base.util.RequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

public abstract class AbstractController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String JSON_SUCCESS = "{\"code\":0,\"msg\":\"ok\"}";
    public static final String JSON_FAIL = "{\"code\":1,\"msg\":\"\u53c2\u6570\u9519\u8bef\uff01\"}";
    public static final String REDIRECT = "redirect:";

    protected File transferFile(MultipartFile myfile, String file) {
        File dest = new File(file);
        FileUtil.makeDir((File)dest.getParentFile());
        try {
            myfile.transferTo(dest);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dest;
    }

    protected String getRefer(HttpServletRequest request) {
        return request.getHeader("Referer");
    }

    public static <E> Page<E> newPage(HttpServletRequest request) {
        Page page = new Page();
        int curpage = RequestUtil.getParamInt((ServletRequest)request, (String)"page", (int)1);
        if (curpage < 1) {
            curpage = 1;
        }
        page.setPage(curpage);
        page.setRows(RequestUtil.getParamInt((ServletRequest)request, (String)"rows", (int)20));
        page.setUri(request.getRequestURI());
        page.setQuery((Map)RequestUtil.getParameterMap((ServletRequest)request));
        page.setCount(RequestUtil.getParamInt((ServletRequest)request, (String)"count", (int)0));
        request.setAttribute("pages", (Object)page);
        return page;
    }

    protected String getHost(String url) {
        if (!DataUtil.isEmpty((String)url)) {
            try {
                URL domain = new URL(url);
                String host = domain.getHost();
                return host;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    protected String getIp(HttpServletRequest request) {
        return IpUtil.getIp((HttpServletRequest)request);
    }

    protected String wrapJsonCallback(ServletRequest request, String json) {
        String callback = request.getParameter("callback");
        return DataUtil.isEmpty((String)callback) ? json : String.format("%s(%s)", HtmlUtils.htmlEscape((String)callback), json);
    }

    protected void logErr(HttpServletRequest request) {
        this.logger.error("request: {}", (Object)RequestUtil.getURL((HttpServletRequest)request));
        this.logger.error(":UA=" + request.getHeader("User-Agent") + "[refer=" + this.getRefer(request) + "][ajax=" + request.getHeader("X-Requested-With"));
    }

    @ExceptionHandler(value={Throwable.class})
    public void handleException(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        this.logErr(request);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        JSONObject s = new JSONObject();
        s.put("code", (Object)9999);
        s.put("msg", (Object)e.getMessage());
        try {
            request.setCharacterEncoding("UTF-8");
            response.getWriter().write(s.toJSONString());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }
}

