/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import java.util.List;
import java.util.Map;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import jmind.core.redis.AbstractJedis;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;

public class SingleJedis
extends AbstractJedis {
    private final JedisPool pool;

    public SingleJedis(String name, IProperties p) {
        this(p.getProperty("redis." + name + ".host"), DataUtil.toInt((String)p.getProperty("redis." + name + ".timeout", "2")) * 1000, DataUtil.toInt((String)p.getProperty("redis." + name + ".maxTotal", "100")), DataUtil.toInt((String)p.getProperty("redis." + name + ".maxIdle", "100")), p.getProperty("redis." + name + ".password"));
    }

    public SingleJedis(String host, int timeout, int maxActive, int maxIdle, String password) {
        String[] h = host.split(":");
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(maxActive);
        config.setMaxIdle(maxIdle);
        config.setTestOnBorrow(true);
        this.pool = new JedisPool((GenericObjectPoolConfig)config, h[0], Integer.parseInt(h[1]), timeout * 1000, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long del(String ... keys) {
        Jedis jedis = this.pool.getResource();
        try {
            long l = jedis.del(keys);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> mget(String ... keys) {
        Jedis jedis = this.pool.getResource();
        try {
            List list = jedis.mget(keys);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zaddKV(String key, Map<String, Double> memberScores) {
        Jedis jedis = this.getResource();
        try {
            Pipeline pipelined = jedis.pipelined();
            for (Map.Entry<String, Double> entry : memberScores.entrySet()) {
                pipelined.zadd(key, entry.getValue().doubleValue(), entry.getKey());
            }
            pipelined.sync();
        }
        finally {
            this.close(jedis);
        }
        return 1L;
    }

    public boolean ping() {
        Jedis jedis = null;
        try {
            jedis = this.pool.getResource();
            boolean bl = "PONG".equalsIgnoreCase(jedis.ping());
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.close(jedis);
        }
        return false;
    }

    public Jedis getResource() {
        return this.pool.getResource();
    }

    @Override
    public void close(Object resource) {
        Jedis jedis = (Jedis)resource;
        if (jedis != null) {
            jedis.close();
        }
    }

    @Override
    public void releaseResource() {
        this.pool.destroy();
    }
}

