/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import jmind.core.redis.AbstractJedis;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;

public class ShardedRedis
extends AbstractJedis {
    private final ShardedJedisPool shardPool;

    public ShardedRedis(String name, IProperties p) {
        this(p.getProperty("redis." + name + ".host"), DataUtil.toInt((String)p.getProperty("redis." + name + ".timeout", "2")) * 1000, DataUtil.toInt((String)p.getProperty("redis." + name + ".maxTotal", "100")), DataUtil.toInt((String)p.getProperty("redis." + name + ".maxIdle", "100")), p.getProperty("redis." + name + ".password"));
    }

    public ShardedRedis(String hosts, int timeout, int maxActive, int maxIdle, String password) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(maxActive);
        config.setMaxIdle(maxIdle);
        config.setMaxWaitMillis(1000L);
        config.setTestOnBorrow(true);
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        for (String host : hosts.split(",")) {
            String[] hostAndPort = host.split(":");
            JedisShardInfo info = new JedisShardInfo(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
            info.setSoTimeout(timeout * 1000);
            info.setPassword(password);
            shards.add(info);
        }
        this.shardPool = new ShardedJedisPool((GenericObjectPoolConfig)config, shards);
    }

    public ShardedJedis getResource() {
        return this.shardPool.getResource();
    }

    @Override
    public void close(Object resource) {
        if (resource != null) {
            ShardedJedis jedis = (ShardedJedis)resource;
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long del(String ... keys) {
        long i = 0L;
        ShardedJedis jedis = this.getResource();
        try {
            for (String key : keys) {
                i += jedis.del(key).longValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(jedis);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> mget(String ... keys) {
        ShardedJedis jedis = this.getResource();
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (String key : keys) {
                list.add(jedis.get(key));
            }
        }
        finally {
            this.close(jedis);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zaddKV(String key, Map<String, Double> memberScores) {
        ShardedJedis jedis = this.getResource();
        try {
            ShardedJedisPipeline pipelined = jedis.pipelined();
            for (Map.Entry<String, Double> entry : memberScores.entrySet()) {
                pipelined.zadd(key, entry.getValue().doubleValue(), entry.getKey());
            }
            pipelined.sync();
        }
        finally {
            this.close(jedis);
        }
        return 1L;
    }

    @Override
    public void releaseResource() {
        this.shardPool.destroy();
    }
}

