/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import jmind.core.redis.Redis;

public class RedisDistributedLock {
    private final int EXPIRE_TIME;
    private final int WAIT_TIME;
    private final Redis jedis;

    public RedisDistributedLock(Redis redis, int expireTime, int waitTime) {
        this.EXPIRE_TIME = expireTime;
        this.WAIT_TIME = waitTime;
        this.jedis = redis;
    }

    public boolean tryLock(String key) {
        return this.tryLock(key, 0L);
    }

    public boolean tryLock(String key, long timeout) {
        long nano = System.currentTimeMillis();
        do {
            Long i;
            if ((i = this.jedis.setnx(key, key)) == 1L) {
                this.jedis.expire(key, this.EXPIRE_TIME);
                return Boolean.TRUE;
            }
            if (timeout == 0L) break;
            try {
                Thread.sleep(this.WAIT_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (System.currentTimeMillis() - nano <= timeout);
        return Boolean.FALSE;
    }

    public void lock(String key) {
        try {
            while (true) {
                Long i;
                if ((i = this.jedis.setnx(key, key)) == 1L) {
                    this.jedis.expire(key, this.EXPIRE_TIME);
                    return;
                }
                Thread.sleep(this.WAIT_TIME);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unLock(String key) {
        this.jedis.del(key);
    }
}

