/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import jmind.base.lang.ScoreValue;
import jmind.base.lang.shard.LoadBalance;
import jmind.base.util.DataUtil;
import jmind.core.redis.Redis;
import jmind.core.redis.SingleJedis;

public class LoadBalanceRedis
implements Redis {
    final LoadBalance<Redis> balance;

    public LoadBalanceRedis(LoadBalance<Redis> balance) {
        this.balance = balance;
    }

    public LoadBalanceRedis(String hosts, int timeout, LoadBalance.Balance b) {
        CopyOnWriteArrayList<SingleJedis> redis = new CopyOnWriteArrayList<SingleJedis>();
        for (String host : hosts.split(",")) {
            redis.add(new SingleJedis(host, timeout, 30, 30, null));
        }
        this.balance = LoadBalance.create(redis, (LoadBalance.Balance)b);
    }

    private final Redis getShard(String key) {
        return (Redis)this.balance.getShard(key);
    }

    @Override
    public Object getResource() {
        return null;
    }

    @Override
    public void releaseResource() {
    }

    @Override
    public void close(Object resource) {
    }

    @Override
    public boolean setObject(String key, Object o) {
        return this.getShard(key).setObject(key, o);
    }

    @Override
    public boolean setObject(String key, int seconds, Object o) {
        return this.getShard(key).setObject(key, seconds, o);
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        return this.getShard(key).getObject(key, clazz);
    }

    @Override
    public <T> List<T> getArray(String key, Class<T> clazz) {
        return this.getShard(key).getArray(key, clazz);
    }

    @Override
    public String set(String key, String value) {
        return this.getShard(key).set(key, value);
    }

    @Override
    public long del(String ... keys) {
        int k = 0;
        for (String key : keys) {
            k = (int)((long)k + this.getShard(key).del(key));
        }
        return k;
    }

    @Override
    public String get(String key) {
        return this.getShard(key).get(key);
    }

    @Override
    public List<String> mget(String ... keys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : keys) {
            String val = this.get(key);
            if (DataUtil.isEmpty((String)val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public Boolean exists(String key) {
        return this.getShard(key).exists(key);
    }

    @Override
    public String type(String key) {
        return this.getShard(key).type(key);
    }

    @Override
    public boolean expire(String key, int seconds) {
        return this.getShard(key).expire(key, seconds);
    }

    @Override
    public boolean expireAt(String key, long unixTime) {
        return this.getShard(key).expireAt(key, unixTime);
    }

    @Override
    public Long ttl(String key) {
        return this.getShard(key).ttl(key);
    }

    @Override
    public Long setbit(String key, long offset, int value) {
        return this.getShard(key).setbit(key, offset, value);
    }

    @Override
    public Long getbit(String key, long offset) {
        return this.getShard(key).getbit(key, offset);
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        return this.getShard(key).setrange(key, offset, value);
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        return this.getShard(key).getrange(key, startOffset, endOffset);
    }

    @Override
    public String getSet(String key, String value) {
        return this.getShard(key).getSet(key, value);
    }

    @Override
    public Long setnx(String key, String value) {
        return this.getShard(key).setnx(key, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return this.getShard(key).setex(key, seconds, value);
    }

    @Override
    public Long decrBy(String key, long integer) {
        return this.getShard(key).decrBy(key, integer);
    }

    @Override
    public Long decr(String key) {
        return this.getShard(key).decr(key);
    }

    @Override
    public Long incrBy(String key, long integer) {
        return this.getShard(key).incrBy(key, integer);
    }

    @Override
    public Long incr(String key) {
        return this.getShard(key).incr(key);
    }

    @Override
    public Long append(String key, String value) {
        return this.getShard(key).append(key, value);
    }

    @Override
    public String substr(String key, int start, int end) {
        return this.getShard(key).substr(key, start, end);
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.getShard(key).hset(key, field, value);
    }

    @Override
    public String hget(String key, String field) {
        return this.getShard(key).hget(key, field);
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        return this.getShard(key).hsetnx(key, field, value);
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        return this.getShard(key).hmset(key, hash);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        return this.getShard(key).hmget(key, fields);
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.getShard(key).hincrBy(key, field, value);
    }

    @Override
    public Boolean hexists(String key, String field) {
        return this.getShard(key).hexists(key, field);
    }

    @Override
    public Long hdel(String key, String ... field) {
        return this.getShard(key).hdel(key, field);
    }

    @Override
    public Long hlen(String key) {
        return this.getShard(key).hlen(key);
    }

    @Override
    public Set<String> hkeys(String key) {
        return this.getShard(key).hkeys(key);
    }

    @Override
    public List<String> hvals(String key) {
        return this.getShard(key).hvals(key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.getShard(key).hgetAll(key);
    }

    @Override
    public Long rpush(String key, String ... string) {
        return this.getShard(key).rpush(key, string);
    }

    @Override
    public Long lpush(String key, String ... string) {
        return this.getShard(key).lpush(key, string);
    }

    @Override
    public Long llen(String key) {
        return this.getShard(key).llen(key);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return this.getShard(key).lrange(key, start, end);
    }

    @Override
    public List<String> lrevrange(String key, long start, long end) {
        return this.getShard(key).lrevrange(key, start, end);
    }

    @Override
    public String ltrim(String key, long start, long end) {
        return this.getShard(key).ltrim(key, start, end);
    }

    @Override
    public String lindex(String key, long index) {
        return this.getShard(key).lindex(key, index);
    }

    @Override
    public String lset(String key, long index, String value) {
        return this.getShard(key).lset(key, index, value);
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return this.getShard(key).lrem(key, count, value);
    }

    @Override
    public String lpop(String key) {
        return this.getShard(key).lpop(key);
    }

    @Override
    public String rpop(String key) {
        return this.getShard(key).rpop(key);
    }

    @Override
    public Long sadd(String key, String ... member) {
        return this.getShard(key).sadd(key, member);
    }

    @Override
    public Set<String> smembers(String key) {
        return this.getShard(key).smembers(key);
    }

    @Override
    public Long srem(String key, String ... member) {
        return this.getShard(key).srem(key, member);
    }

    @Override
    public String spop(String key) {
        return this.getShard(key).spop(key);
    }

    @Override
    public Long scard(String key) {
        return this.getShard(key).scard(key);
    }

    @Override
    public Boolean sismember(String key, String member) {
        return this.getShard(key).sismember(key, member);
    }

    @Override
    public String srandmember(String key) {
        return this.getShard(key).srandmember(key);
    }

    @Override
    public Long zadd(String key, double score, String member) {
        return this.getShard(key).zadd(key, score, member);
    }

    @Override
    public Long zadd(String key, Map<String, Double> memberScore) {
        return this.getShard(key).zadd(key, memberScore);
    }

    @Override
    public List<String> zrange(String key, long start, long end) {
        return this.getShard(key).zrange(key, start, end);
    }

    @Override
    public Long zrem(String key, String ... member) {
        return this.getShard(key).zrem(key, member);
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return this.getShard(key).zincrby(key, score, member);
    }

    @Override
    public Long zrank(String key, String member) {
        return this.getShard(key).zrank(key, member);
    }

    @Override
    public Long zrevrank(String key, String member) {
        return this.getShard(key).zrevrank(key, member);
    }

    @Override
    public List<String> zrevrange(String key, long start, long end) {
        return this.getShard(key).zrevrange(key, start, end);
    }

    @Override
    public List<ScoreValue<String>> zrangeWithScores(String key, long start, long end) {
        return this.getShard(key).zrangeWithScores(key, start, end);
    }

    @Override
    public List<ScoreValue<String>> zrevrangeWithScores(String key, long start, long end) {
        return this.getShard(key).zrevrangeWithScores(key, start, end);
    }

    @Override
    public Long zcard(String key) {
        return this.getShard(key).zcard(key);
    }

    @Override
    public Double zscore(String key, String member) {
        return this.getShard(key).zscore(key, member);
    }

    @Override
    public List<String> sort(String key) {
        return this.getShard(key).sort(key);
    }

    @Override
    public Long zcount(String key, double min, double max) {
        return this.getShard(key).zcount(key, min, max);
    }

    @Override
    public Long zcount(String key, String min, String max) {
        return this.getShard(key).zcount(key, min, max);
    }

    @Override
    public List<String> zrangeByScore(String key, double min, double max) {
        return this.getShard(key).zrangeByScore(key, min, max);
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max) {
        return this.getShard(key).zrangeByScore(key, min, max);
    }

    @Override
    public List<String> zrevrangeByScore(String key, double max, double min) {
        return this.getShard(key).zrevrangeByScore(key, max, min);
    }

    @Override
    public List<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return this.getShard(key).zrevrangeByScore(key, min, max, offset, count);
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.getShard(key).zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public List<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return this.getShard(key).zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.getShard(key).zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        return this.getShard(key).zremrangeByRank(key, start, end);
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        return this.getShard(key).zremrangeByScore(key, start, end);
    }

    @Override
    public Long linsert(String key, boolean before, String pivot, String value) {
        return this.getShard(key).linsert(key, before, pivot, value);
    }

    @Override
    public Long lpushx(String key, String string) {
        return this.getShard(key).lpushx(key, string);
    }

    @Override
    public Long rpushx(String key, String string) {
        return this.getShard(key).rpushx(key, string);
    }

    @Override
    public List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max) {
        return this.getShard(key).zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.getShard(key).zrangeByScoreWithScores(key, max, min);
    }

    @Override
    public List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.getShard(key).zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.getShard(key).zrangeByScoreWithScores(key, max, min, offset, count);
    }
}

