/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import jmind.base.lang.shard.LoadBalance;
import jmind.core.redis.LoadBalanceRedis;
import jmind.core.redis.Redis;
import jmind.core.redis.SingleJedis;

public class HyneaLoadBalanceRedis
extends LoadBalanceRedis {
    private final List<Redis> redisList;

    public HyneaLoadBalanceRedis(String hosts, int timeout, LoadBalance.Balance b) {
        super(hosts, timeout, b);
        this.redisList = new ArrayList<Redis>(this.balance.getShards());
        if (this.balance.getFisrt() instanceof SingleJedis) {
            this.startHealthExamination();
        }
    }

    private void startHealthExamination() {
        Timer timer = new Timer("healthExamination", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                HyneaLoadBalanceRedis.this.healthExamination();
            }
        }, TimeUnit.MINUTES.toMillis(1L), TimeUnit.SECONDS.toMillis(15L));
    }

    private void healthExamination() {
        for (Redis redis : this.redisList) {
            try {
                boolean health = ((SingleJedis)redis).ping();
                if (this.balance.getShards().contains(redis)) {
                    if (health) continue;
                    this.balance.getShards().remove(redis);
                    continue;
                }
                if (!health) continue;
                this.balance.getShards().add(redis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

