/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;

public class RabbitmqFactory {
    private final ConcurrentMap<String, ConnectionFactory> RESOURCES = new ConcurrentHashMap<String, ConnectionFactory>();
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();

    public static RabbitmqFactory getFactory() {
        return Nested.instance;
    }

    private ConnectionFactory create(String name, IProperties p) {
        String password;
        String username;
        System.out.println("create mq factory " + name);
        String prefix = "rabbitmq." + name;
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(p.getProperty(prefix + ".host"));
        if (p.hasProperty(prefix + ".port")) {
            factory.setPort(DataUtil.toInt((String)p.getProperty(prefix + ".port")));
        }
        factory.setAutomaticRecoveryEnabled(true);
        factory.setConnectionTimeout(3000);
        String vhost = p.getProperty(prefix + ".vhost");
        if (!DataUtil.isEmpty((String)vhost)) {
            factory.setVirtualHost(vhost);
        }
        if (!DataUtil.isEmpty((String)(username = p.getProperty(prefix + ".username")))) {
            factory.setUsername(username);
        }
        if (!DataUtil.isEmpty((String)(password = p.getProperty(prefix + ".password")))) {
            factory.setPassword(password);
        }
        return factory;
    }

    public synchronized ConnectionFactory get(String name, IProperties p) {
        if (this.RESOURCES.containsKey(name)) {
            return (ConnectionFactory)this.RESOURCES.get(name);
        }
        ConnectionFactory factory = this.create(name, p);
        this.RESOURCES.putIfAbsent(name, factory);
        return factory;
    }

    public synchronized Connection getConnection(String name, IProperties p) {
        if ("1".equals(p.getProperty("rabbitmq." + name + ".connections"))) {
            if (this.connections.containsKey(name)) {
                return (Connection)this.connections.get(name);
            }
            try {
                Connection connection = this.create(name, p).newConnection();
                this.connections.putIfAbsent(name, connection);
                return connection;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        } else {
            try {
                return this.get(name, p).newConnection();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static class Nested {
        private static final RabbitmqFactory instance = new RabbitmqFactory();

        Nested() {
        }
    }
}

