/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import jmind.base.lang.IProperties;
import jmind.base.util.GlobalConstants;
import jmind.core.rabbitmq.RabbitmqFactory;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitmqConsumer
implements Consumer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Channel channel;
    private boolean autoAck;

    public RabbitmqConsumer(String name, IProperties p, String queueName, String exchangeName, String routeKey, boolean autoAck) throws IOException, TimeoutException {
        this.logger.debug("name={},queueName={},exchangeName={},routeKey={}", new Object[]{name, queueName, exchangeName, routeKey});
        this.autoAck = autoAck;
        final Connection connection = RabbitmqFactory.getFactory().getConnection(name, p);
        this.channel = connection.createChannel();
        this.channel.basicQos(30);
        try {
            this.channel.queueDeclare(queueName, true, false, false, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.channel.queueBind(queueName, exchangeName, routeKey);
        this.channel.basicConsume(queueName, autoAck, (Consumer)this);
        if (connection != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        RabbitmqConsumer.this.channel.close();
                        connection.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    protected abstract boolean consume(Envelope var1, byte[] var2);

    public void handleConsumeOk(String consumerTag) {
    }

    public void handleCancelOk(String consumerTag) {
    }

    public void handleCancel(String consumerTag) throws IOException {
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
    }

    public void handleRecoverOk(String consumerTag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.logger.debug("consume-{}={}", (Object)envelope.getRoutingKey(), (Object)new String(body, GlobalConstants.CHARSET_UTF8));
        Slf4JStopWatch stopWatch = new Slf4JStopWatch("shell");
        boolean dealRet = false;
        try {
            dealRet = this.consume(envelope, body);
        }
        finally {
            stopWatch.stop(envelope.getRoutingKey());
            if (!this.autoAck) {
                if (dealRet) {
                    this.channel.basicAck(envelope.getDeliveryTag(), false);
                } else {
                    this.channel.basicReject(envelope.getDeliveryTag(), true);
                }
            }
        }
    }

    public Channel getChannel() {
        return this.channel;
    }
}

