/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.poi;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jmind.base.util.DataUtil;
import jmind.base.util.DateUtil;
import jmind.core.poi.Excel;
import jmind.core.support.BeanProperty;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxExcel
extends Excel {
    static final XlsxExcel INSTANCE = new XlsxExcel();

    @Override
    public Workbook exportExcel(String sheetName, List<?> datas) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle textCellStyle = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        textCellStyle.setDataFormat(format.getFormat("@"));
        XSSFSheet sheet = workbook.createSheet(sheetName);
        for (int rownum = 0; rownum < datas.size(); ++rownum) {
            XSSFRow row = sheet.createRow(rownum);
            XSSFCell cell = row.createCell(0, 1);
            cell.setCellStyle((CellStyle)textCellStyle);
            cell.setCellValue(datas.get(rownum).toString());
        }
        return workbook;
    }

    @Override
    public <T> Workbook exportExcel(String sheetName, List<T> dataset, String[] headers) {
        return this.exportExcel(sheetName, dataset, headers, "yyyy-MM-dd HH:mm:ss");
    }

    public <T> XSSFWorkbook exportExcel(String sheetName, List<T> dataset, String[] headers, String dateFormart) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(15);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor((short)40);
        style.setFillPattern((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        XSSFFont font = workbook.createFont();
        font.setColor((short)20);
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        style.setFont((Font)font);
        XSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor((short)43);
        style2.setFillPattern((short)1);
        style2.setBorderBottom((short)1);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setAlignment((short)2);
        style2.setVerticalAlignment((short)1);
        XSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)400);
        style2.setFont((Font)font2);
        XSSFDrawing patriarch = sheet.createDrawingPatriarch();
        XSSFComment comment = patriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new XSSFRichTextString("\u53ef\u4ee5\u5728POI\u4e2d\u6dfb\u52a0\u6ce8\u91ca\uff01"));
        Field[] fields = dataset.get(0).getClass().getDeclaredFields();
        if (headers == null) {
            headers = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                headers[i] = fields[i].getName();
            }
        }
        XSSFRow row0 = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            XSSFCell cell = row0.createCell(i);
            cell.setCellStyle((CellStyle)style);
            XSSFRichTextString text = new XSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        for (int index = 0; index < dataset.size(); ++index) {
            XSSFRow row = sheet.createRow(index + 1);
            T t = dataset.get(index);
            for (int i = 0; i < fields.length; ++i) {
                XSSFCell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style2);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    if (value == null) {
                        cell.setCellValue("");
                        continue;
                    }
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(dateFormart);
                        textValue = sdf.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, 2856);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(2);
                        patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(bsValue, 5));
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    XSSFRichTextString richString = new XSSFRichTextString(textValue);
                    XSSFFont font3 = workbook.createFont();
                    font3.setColor((short)12);
                    richString.applyFont((Font)font3);
                    cell.setCellValue((RichTextString)richString);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return workbook;
    }

    @Override
    public <T> Workbook exportExcel(String sheetName, List<T> dataset, String[] headers, String[] methods) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        if (DataUtil.isEmpty(dataset)) {
            return workbook;
        }
        XSSFCellStyle textCellStyle = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        textCellStyle.setDataFormat(format.getFormat("@"));
        XSSFSheet sheet = workbook.createSheet(sheetName);
        XSSFRow firstRow = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            XSSFCell cell = firstRow.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headers[i]);
        }
        Class<?> target = dataset.get(0).getClass();
        for (int rownum = 0; rownum < dataset.size(); ++rownum) {
            T obj = dataset.get(rownum);
            XSSFRow row = sheet.createRow(rownum + 1);
            for (int columnIndex = 0; columnIndex < methods.length; ++columnIndex) {
                try {
                    XSSFCell cell = row.createCell(columnIndex, 1);
                    cell.setCellStyle((CellStyle)textCellStyle);
                    Method method = target.getMethod(methods[columnIndex], new Class[0]);
                    Object value = method.invoke(obj, new Object[0]);
                    if (value == null) continue;
                    if (value instanceof Date) {
                        cell.setCellValue(DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    cell.setCellValue(value.toString());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return workbook;
    }

    @Override
    public Workbook exportMapExcel(String sheetName, List<Map<String, String>> objList) {
        if (DataUtil.isEmpty(objList)) {
            return null;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(sheetName);
        for (int i = 0; i < objList.size(); ++i) {
            Map<String, String> map = objList.get(i);
            XSSFRow row = sheet.createRow(i);
            int j = 0;
            for (String k : map.values()) {
                XSSFCell cell = row.createCell(j++);
                cell.setCellType(1);
                cell.setCellValue(k);
            }
        }
        return workbook;
    }

    @Override
    public List<String> excel2StrList(InputStream in) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)sheet.getPhysicalNumberOfRows());
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                XSSFRow row = sheet.getRow(i);
                try {
                    XSSFCell cell = row.getCell(0);
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    if (DataUtil.isEmpty((String)value)) continue;
                    list.add(value);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return list;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public <T> List<T> excel2List(InputStream in, Class<T> claz, String[] fields, int start) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)sheet.getPhysicalNumberOfRows());
            if (fields == null) {
                XSSFRow row = sheet.getRow(0);
                fields = new String[row.getPhysicalNumberOfCells()];
                for (int i = 0; i < row.getPhysicalNumberOfCells(); ++i) {
                    fields[i] = row.getCell(i).getStringCellValue();
                }
            }
            for (int i = start; i < sheet.getPhysicalNumberOfRows(); ++i) {
                BeanProperty<T> bean = new BeanProperty<T>(claz);
                XSSFRow row = sheet.getRow(i);
                for (int j = 0; j < fields.length; ++j) {
                    if (DataUtil.isEmpty((String)fields[j])) continue;
                    try {
                        XSSFCell cell = row.getCell(j);
                        cell.setCellType(1);
                        String value = cell.getStringCellValue();
                        if (value == null) continue;
                        bean.setProperty(fields[j], value.trim());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                list.add(bean.get());
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public List<Map<String, String>> excel2Map(InputStream in, String[] strKey) {
        try {
            XSSFRow row;
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)sheet.getPhysicalNumberOfRows());
            for (int rowIndex = sheet.getFirstRowNum() + 1; rowIndex < sheet.getPhysicalNumberOfRows() && (row = sheet.getRow(rowIndex)) != null && row.getFirstCellNum() >= 0; ++rowIndex) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (int cellIndex = row.getFirstCellNum(); cellIndex < strKey.length; ++cellIndex) {
                    String key = strKey[cellIndex];
                    XSSFCell cell = row.getCell(cellIndex);
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    map.put(key, value);
                }
                list.add(map);
            }
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

