/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.poi;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jmind.base.util.DataUtil;
import jmind.base.util.DateUtil;
import jmind.base.util.MethodUtil;
import jmind.core.poi.Excel;
import jmind.core.support.BeanProperty;
import jmind.core.support.MethodSupport;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsExcel
extends Excel {
    static final XlsExcel INSTANCE = new XlsExcel();

    private void createTitle(HSSFSheet sheet, String[] title) {
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = null;
        for (int i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(title[i]);
        }
    }

    @Override
    public Workbook exportExcel(String sheetName, List<?> datas) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle textCellStyle = workbook.createCellStyle();
        HSSFDataFormat format = workbook.createDataFormat();
        textCellStyle.setDataFormat(format.getFormat("@"));
        HSSFSheet sheet = workbook.createSheet(sheetName);
        for (int rownum = 0; rownum < datas.size(); ++rownum) {
            HSSFRow row = sheet.createRow(rownum);
            HSSFCell cell = row.createCell(0, 1);
            cell.setCellStyle(textCellStyle);
            cell.setCellValue(datas.get(rownum).toString());
        }
        return workbook;
    }

    @Override
    public <T> Workbook exportExcel(String sheetName, List<T> dataset, String[] headers) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (DataUtil.isEmpty(dataset)) {
            return workbook;
        }
        HSSFCellStyle textCellStyle = workbook.createCellStyle();
        HSSFDataFormat format = workbook.createDataFormat();
        textCellStyle.setDataFormat(format.getFormat("@"));
        HSSFSheet sheet = workbook.createSheet(sheetName);
        Field[] fields = dataset.get(0).getClass().getDeclaredFields();
        if (headers == null) {
            headers = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                headers[i] = fields[i].getName();
            }
        }
        this.createTitle(sheet, headers);
        for (int rownum = 0; rownum < dataset.size(); ++rownum) {
            T obj = dataset.get(rownum);
            HSSFRow row = sheet.createRow(rownum + 1);
            for (int columnIndex = 0; columnIndex < fields.length; ++columnIndex) {
                try {
                    HSSFCell cell = row.createCell(columnIndex, 1);
                    cell.setCellStyle(textCellStyle);
                    String value = MethodSupport.getProperty(obj, fields[columnIndex].getName());
                    if (value == null) continue;
                    cell.setCellValue(value);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return workbook;
    }

    @Override
    public <T> Workbook exportExcel(String sheetName, List<T> dataset, String[] headers, String[] methods) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (DataUtil.isEmpty(dataset)) {
            return workbook;
        }
        HSSFCellStyle textCellStyle = workbook.createCellStyle();
        HSSFDataFormat format = workbook.createDataFormat();
        textCellStyle.setDataFormat(format.getFormat("@"));
        HSSFSheet sheet = workbook.createSheet(sheetName);
        this.createTitle(sheet, headers);
        for (int rownum = 0; rownum < dataset.size(); ++rownum) {
            T obj = dataset.get(rownum);
            HSSFRow row = sheet.createRow(rownum + 1);
            for (int columnIndex = 0; columnIndex < methods.length; ++columnIndex) {
                try {
                    HSSFCell cell = row.createCell(columnIndex, 1);
                    cell.setCellStyle(textCellStyle);
                    Object value = MethodUtil.invokeMethod(obj, (String)methods[columnIndex], (Object[])new Object[0]);
                    if (value == null) continue;
                    if (value instanceof Date) {
                        cell.setCellValue(DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    cell.setCellValue(value.toString());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return workbook;
    }

    @Override
    public Workbook exportMapExcel(String sheetName, List<Map<String, String>> objList) {
        if (DataUtil.isEmpty(objList)) {
            return null;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        for (int i = 0; i < objList.size(); ++i) {
            Map<String, String> map = objList.get(i);
            HSSFRow row = sheet.createRow(i);
            int j = 0;
            for (String k : map.values()) {
                HSSFCell cell = row.createCell(j++);
                cell.setCellType(1);
                cell.setCellValue(k);
            }
        }
        return workbook;
    }

    @Override
    public List<String> excel2StrList(InputStream in) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(in);
            HSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)sheet.getPhysicalNumberOfRows());
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                HSSFRow row = sheet.getRow(i);
                try {
                    HSSFCell cell = row.getCell(0);
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    if (value == null) continue;
                    list.add(value);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public <T> List<T> excel2List(InputStream in, Class<T> claz, String[] fields, int start) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(in);
            HSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)sheet.getPhysicalNumberOfRows());
            if (fields == null) {
                HSSFRow row = sheet.getRow(0);
                fields = new String[row.getPhysicalNumberOfCells()];
                for (int i = 0; i < row.getPhysicalNumberOfCells(); ++i) {
                    fields[i] = row.getCell(i).getStringCellValue();
                }
            }
            for (int i = start; i < sheet.getPhysicalNumberOfRows(); ++i) {
                BeanProperty<T> bean = new BeanProperty<T>(claz);
                HSSFRow row = sheet.getRow(i);
                for (int j = 0; j < fields.length; ++j) {
                    if (DataUtil.isEmpty((String)fields[j])) continue;
                    try {
                        HSSFCell cell = row.getCell(j);
                        cell.setCellType(1);
                        String value = cell.getStringCellValue();
                        if (value == null) continue;
                        bean.setProperty(fields[j], value.trim());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                list.add(bean.get());
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public List<Map<String, String>> excel2Map(InputStream in, String[] strKey) {
        try {
            HSSFRow row;
            HSSFWorkbook workbook = new HSSFWorkbook(in);
            HSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList listMap = Lists.newArrayListWithExpectedSize((int)sheet.getPhysicalNumberOfRows());
            for (int rowIndex = sheet.getFirstRowNum() + 1; rowIndex < sheet.getPhysicalNumberOfRows() && (row = sheet.getRow(rowIndex)) != null && row.getFirstCellNum() >= 0; ++rowIndex) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (int cellIndex = row.getFirstCellNum(); cellIndex < strKey.length; ++cellIndex) {
                    String key = strKey[cellIndex];
                    HSSFCell cell = row.getCell(cellIndex);
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    map.put(key, value);
                }
                listMap.add(map);
            }
            return listMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

