/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.manager;

import java.util.concurrent.FutureTask;
import jmind.base.util.DataUtil;
import jmind.core.manager.AbstractManager;
import jmind.core.redis.NioRedis;
import jmind.core.redis.Redis;
import jmind.core.redis.RedisCluster;
import jmind.core.redis.ShardedRedis;
import jmind.core.redis.SingleJedis;

public class RedisManager
extends AbstractManager<Redis> {
    private static volatile RedisManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisManager getInstance() {
        if (manager != null) return manager;
        Class<RedisManager> clazz = RedisManager.class;
        synchronized (RedisManager.class) {
            if (manager != null) return manager;
            manager = new RedisManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @Override
    public Redis create(String name) {
        Redis redis;
        String hosts = this.getProperties().getProperty("redis." + name + ".host");
        int timeout = DataUtil.toInt((String)this.getProperties().getProperty("redis." + name + ".timeout", "30"));
        try {
            Class.forName("jmind.redis.RedisBootstrap2");
            redis = new NioRedis(hosts, timeout);
            this.logger.debug("init nio redis {}={}, timeout={}", new Object[]{name, hosts, timeout});
        }
        catch (ClassNotFoundException e) {
            String mode = this.getProperties().getProperty("redis." + name + ".mode");
            this.logger.debug("init  jedis {}={}, timeout={}", new Object[]{name, hosts, timeout});
            redis = "cluster".equals(mode) ? new RedisCluster(name, this.getProperties()) : (hosts.contains(",") ? new ShardedRedis(name, this.getProperties()) : new SingleJedis(name, this.getProperties()));
        }
        return redis;
    }

    @Override
    public void releaseResource() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (FutureTask redis : RedisManager.this.RESOURCES.values()) {
                    try {
                        ((Redis)redis.get()).releaseResource();
                    }
                    catch (Exception e) {
                        RedisManager.this.logger.error("", (Throwable)e);
                    }
                }
                RedisManager.this.logger.debug("releaseResource {}", (Object)this.getClass().getName());
            }
        });
    }
}

