/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.manager;

import java.util.concurrent.FutureTask;
import javax.sql.DataSource;
import jmind.core.jdbc.DataSourceUtil;
import jmind.core.manager.AbstractManager;
import org.apache.commons.dbcp.BasicDataSource;

public class DataSourceManager
extends AbstractManager<DataSource> {
    private static volatile DataSourceManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSourceManager getInstance() {
        if (manager != null) return manager;
        Class<DataSourceManager> clazz = DataSourceManager.class;
        synchronized (DataSourceManager.class) {
            if (manager != null) return manager;
            manager = new DataSourceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @Override
    public DataSource create(String name) {
        return DataSourceUtil.createSource(name, this.getProperties());
    }

    @Override
    public void releaseResource() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (FutureTask source : DataSourceManager.this.RESOURCES.values()) {
                    try {
                        BasicDataSource ds = (BasicDataSource)source.get();
                        ds.close();
                    }
                    catch (Exception e) {
                        DataSourceManager.this.logger.error("DataSourceManager releaseResource error!", (Throwable)e);
                    }
                }
                DataSourceManager.this.logger.debug("releaseResource {}", (Object)this.getClass().getName());
            }
        });
    }
}

