/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.manager;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;

public abstract class AbstractMongoManager {
    private final String MONGO_PREFIX = "mongo.";
    private final Map<String, DB> dbs = new ConcurrentHashMap<String, DB>();

    public abstract IProperties getProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB getResource(String name) {
        DB db = this.dbs.get(name);
        if (db == null) {
            Map<String, DB> map = this.dbs;
            synchronized (map) {
                if (this.dbs.containsKey(name)) {
                    return this.dbs.get(name);
                }
                db = this.initDB(name);
                this.dbs.put(name, db);
            }
        }
        return db;
    }

    private DB initDB(String name) {
        DB db = null;
        try {
            Mongo mongo;
            String host;
            String configs = this.getProperties().getProperty("mongo." + name);
            System.out.println(configs);
            BasicDBObject config = (BasicDBObject)JSON.parse((String)configs);
            MongoOptions options = new MongoOptions();
            if (config.containsField("options")) {
                BasicDBObject option = (BasicDBObject)config.get("options");
                if (option.containsField("autoConnectRetry")) {
                    options.autoConnectRetry = option.getBoolean("autoConnectRetry");
                }
                if (option.containsField("socketKeepAlive")) {
                    options.socketKeepAlive = option.getBoolean("socketKeepAlive");
                }
                if (option.containsField("connectionsPerHost")) {
                    options.connectionsPerHost = option.getInt("connectionsPerHost");
                }
                if (option.containsField("maxWaitTime")) {
                    options.maxWaitTime = option.getInt("maxWaitTime");
                }
                if (option.containsField("socketTimeout")) {
                    options.socketTimeout = option.getInt("socketTimeout");
                }
                if (option.containsField("connectTimeout")) {
                    options.connectTimeout = option.getInt("connectTimeout");
                }
                if (option.containsField("threadsMultiplier")) {
                    options.threadsAllowedToBlockForConnectionMultiplier = option.getInt("threadsMultiplier");
                }
            }
            if ((host = config.getString("host")).contains(",")) {
                String[] hosts = host.split(",");
                ArrayList<ServerAddress> replicaSetSeeds = new ArrayList<ServerAddress>();
                for (String h : hosts) {
                    replicaSetSeeds.add(new ServerAddress(h));
                }
                mongo = new Mongo(replicaSetSeeds, options);
            } else {
                mongo = new Mongo(host, options);
            }
            db = mongo.getDB(config.getString("db"));
            if (config.containsField("auth")) {
                BasicDBObject auth = (BasicDBObject)config.get("auth");
                db.authenticate(auth.getString("user"), auth.getString("pwd").toCharArray());
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
        return db;
    }

    public DBCollection getSimpleColl(String uri) {
        DBCollection coll = null;
        try {
            String[] config = uri.split("#");
            Mongo mongo = new Mongo(config[0]);
            DB db = mongo.getDB(config[1]);
            coll = db.getCollection(config[2]);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
        return coll;
    }

    public List<DBObject> find(String dbName, String table, String query, String sort, int start, int limit) {
        DB db = this.getResource(dbName);
        DBCollection coll = db.getCollection(table);
        DBObject ref = DataUtil.isEmpty((String)query) ? null : (DBObject)JSON.parse((String)query);
        DBCursor find = coll.find(ref);
        if (!DataUtil.isEmpty((String)sort)) {
            DBObject osort = (DBObject)JSON.parse((String)sort);
            find = find.sort(osort);
        }
        return find.skip(start).limit(limit).toArray();
    }

    public void save(String dbName, String table, String obj) {
        DBObject jo = (DBObject)JSON.parse((String)obj);
        this.save(dbName, table, jo);
    }

    public void save(String dbName, String table, DBObject jo) {
        DB db = this.getResource(dbName);
        DBCollection coll = db.getCollection(table);
        coll.save(jo);
    }

    public void insert(String dbName, String table, Map<?, ?> map) {
        DB db = this.getResource(dbName);
        DBCollection coll = db.getCollection(table);
        coll.insert(new DBObject[]{new BasicDBObject(map)});
    }

    public void insert(String dbName, String table, DBObject ... jo) {
        DB db = this.getResource(dbName);
        DBCollection coll = db.getCollection(table);
        coll.insert(jo);
    }
}

