/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.manager;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import jmind.base.lang.IProperties;
import jmind.base.lang.SourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManager<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ConcurrentMap<String, FutureTask<T>> RESOURCES = new ConcurrentHashMap<String, FutureTask<T>>();

    public AbstractManager() {
        this.releaseResource();
    }

    public T getResource(final String name) {
        FutureTask newTask;
        FutureTask task = (FutureTask)this.RESOURCES.get(name);
        if (task == null && (task = this.RESOURCES.putIfAbsent(name, newTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AbstractManager.this.create(name);
            }
        }))) == null) {
            task = newTask;
            task.run();
        }
        try {
            return (T)task.get();
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    public abstract T create(String var1);

    public IProperties getProperties() {
        return SourceProperties.getDataSource();
    }

    public abstract void releaseResource();
}

