/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import jmind.base.util.ClassUtil;
import jmind.base.util.IpUtil;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public class LogbackConfigure {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{"9527", ClassUtil.getResourcePath((String)"logback.xml")};
            System.out.println("logback path=" + args[1]);
        }
        try {
            SimpleSocketServer.main((String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogbackConfigure.setLocalIp();
    }

    public static void setProperty(String name, String value) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.putProperty(name, value);
    }

    public static void setLocalIp() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.putProperty("nodeIp", IpUtil.getLocalAddress());
    }

    public static void setLevel(String name, String level) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)name);
        logger.setLevel(Level.toLevel((String)level));
    }

    public static void setLevel(Class<?> clazz, Level level) {
        Logger logger = (Logger)LoggerFactory.getLogger(clazz);
        logger.setLevel(level);
    }

    public static void initLogging(String location) throws FileNotFoundException, JoranException {
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)location);
        URL url = ResourceUtils.getURL((String)resolvedLocation);
        LoggerContext loggerContext = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
        loggerContext.reset();
        new ContextInitializer(loggerContext).configureByResource(url);
    }

    public static void setWorkingDirSystemProperty(String key) {
        System.setProperty(key, new File("").getAbsolutePath());
    }

    public static void shutdownLogging() {
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext loggerContext = selector.getLoggerContext();
        String loggerContextName = loggerContext.getName();
        LoggerContext context = selector.detachLoggerContext(loggerContextName);
        context.reset();
    }
}

